/*
 * Decompiled with CFR 0.152.
 */
package puns.common;

import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.PacketDistributor;
import puns.Puns;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.network.HybridPunStatsHandler;
import puns.network.LocalPunStats;
import puns.network.PacketHandler;
import puns.network.PunPackets;
import puns.network.PunStats;

public class ServerEventHandler {
    public static void init(IEventBus bus) {
        bus.addListener(ServerEventHandler::onServerStarting);
        bus.addListener(ServerEventHandler::onPlayerLoggedIn);
    }

    public static void onServerStarting(ServerStartingEvent event) {
        if (!((Boolean)Config.COMMON.enableOnline.get()).booleanValue()) {
            Puns.SERVER_PUN_STATS_HANDLER = new LocalPunStats();
            Puns.debugMessage("Online stats disabled in config --> using local-only stats");
        } else if (((Boolean)Config.COMMON.enableLocalStats.get()).booleanValue()) {
            Puns.SERVER_PUN_STATS_HANDLER = new HybridPunStatsHandler();
            Puns.debugMessage("Hybrid stats mode enabled: remote for official puns, local for custom");
        } else {
            Puns.SERVER_PUN_STATS_HANDLER = new PunStats();
            Puns.debugMessage("Pure remote stats mode: all reactions sent to central server");
        }
        PunDataLoader.loadPuns();
        Puns.debugMessage("Server active puns count: " + PunDataLoader.ACTIVE_PUNS.size());
    }

    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PunPackets.SyncPunsPayload(PunDataLoader.ACTIVE_PUNS));
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PunPackets.SyncConfigPayload((Boolean)Config.COMMON.enableLocalStats.get(), (Boolean)Config.COMMON.enableOnline.get()));
    }
}

