/*
 * Decompiled with CFR 0.152.
 */
package puns.config;

import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final Config COMMON = Config.register(ModConfig.Type.COMMON, Config::new);
    public final ForgeConfigSpec.BooleanValue enableDebug;
    public final ForgeConfigSpec.BooleanValue enableOnline;
    public final ForgeConfigSpec.BooleanValue onlyPuns;
    public final ForgeConfigSpec.BooleanValue enableLocalStats;
    public final ForgeConfigSpec.BooleanValue enablePunsBeforeTitle;
    public final ForgeConfigSpec.BooleanValue enablePunsDuringLevelLoad;

    public static void init() {
    }

    private static <C> C register(ModConfig.Type type, Function<ForgeConfigSpec.Builder, C> factory) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(factory);
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)specPair.getRight());
        return (C)specPair.getLeft();
    }

    Config(ForgeConfigSpec.Builder innerBuilder) {
        Function<String, ForgeConfigSpec.Builder> builder = name -> innerBuilder.translation("puns.config.common." + name);
        innerBuilder.push("Debug");
        this.enableDebug = builder.apply("enableDebug").comment("If true, the mod will print detailed debug information to the log. Useful for troubleshooting or verifying server/client communication. Leave disabled for normal gameplay to avoid clutter in the logs.").define("enableDebug", false);
        innerBuilder.pop();
        this.enableOnline = builder.apply("enableOnline").comment("Where all the fun is kept and distributed from. Enable communication with the external stats server. When true, reactions and pun statistics are sent to and fetched from the backend API. When false, stats are only being stored in memory, and there will be no network requests.").define("enableOnline", true);
        this.onlyPuns = builder.apply("onlyPuns").comment("Controls what happens after reacting to a pun. If false, the game will proceed to the main title menu after a reaction. If true, the game will open another pun screen after a reaction instead, allowing continuous puns without returning to the menu.").define("onlyPuns", false);
        this.enableLocalStats = builder.apply("enableLocalStats").comment("Enable hybrid stats mode. When true (and forceLocalOnly is false), the server and clients will use the local stats database for custom puns, but still send reactions to the remote backend for puns that exactly match the authoritative remote dataset. This setting overrides enableOnline for custom puns, but allows remote syncing when a pun is recognized remotely.").define("enableLocalStats", true);
        this.enablePunsBeforeTitle = builder.apply("enablePunsBeforeTitle").comment("Show a pun screen before the main title menu. This lets players see and react to a pun immediately before entering the main menu (title screen). Disable if you prefer to go straight to the title menu without the very pleasant interruption.").define("enablePunsBeforeTitle", true);
        this.enablePunsDuringLevelLoad = builder.apply("enablePunsDuringLevelLoad").comment("Show a pun screen during world loading. When true, any LevelLoadingScreen (the screen shown while a world is generating or loading) is replaced with the interactive Puns screen. This allows players to see and react to puns while waiting for a level to finish loading. Disable if you prefer the standard loading screen or just really hate puns.").define("enablePunsDuringLevelLoad", false);
    }
}

