/*
 * Decompiled with CFR 0.152.
 */
package puns.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraftforge.fml.loading.FMLPaths;
import puns.Puns;

public class PunDataLoader {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String JSON_DATA_URL = "http://158.178.157.217:5000/api/puns";
    public static boolean USED_REMOTE_ONLY = false;
    public static final File PUNS_FILE = FMLPaths.GAMEDIR.get().resolve("puns/puns.json").toFile();
    public static final File CUSTOM_FILE = FMLPaths.GAMEDIR.get().resolve("puns/custom_puns.json").toFile();
    public static List<PunEntry> REMOTE_PUNS = new ArrayList<PunEntry>();
    public static List<PunEntry> ACTIVE_PUNS = new ArrayList<PunEntry>();
    public static List<PunEntry> SYNCED_PUNS = new ArrayList<PunEntry>();

    public static void reloadPuns() {
        Puns.debugMessage("Reloading all puns");
        REMOTE_PUNS.clear();
        ACTIVE_PUNS.clear();
        SYNCED_PUNS.clear();
        PunDataLoader.loadPuns();
    }

    public static boolean matchesRemotePun(PunEntry pun) {
        if (pun == null) {
            Puns.debugMessage("matchesRemotePun called with null PunEntry! Returning false.");
            return false;
        }
        if (REMOTE_PUNS == null || REMOTE_PUNS.isEmpty()) {
            Puns.debugMessage("No remote puns cached yet \u00e2\u20ac\u201c cannot verify punId=\"" + pun.id() + "\". Treating as custom/local.");
            return false;
        }
        return REMOTE_PUNS.contains(pun);
    }

    public static void loadPuns() {
        ArrayList<PunEntry> authoritative = new ArrayList<PunEntry>();
        ArrayList<PunEntry> custom = new ArrayList<PunEntry>();
        if (PUNS_FILE.exists()) {
            PunDataLoader.loadLocalPuns(PUNS_FILE, authoritative);
            Puns.debugMessage("Loaded puns.json, size=" + authoritative.size());
        } else {
            boolean loadedRemote = PunDataLoader.loadFromUrl(JSON_DATA_URL, authoritative);
            USED_REMOTE_ONLY = loadedRemote && !PUNS_FILE.exists() && !CUSTOM_FILE.exists();
            if (!loadedRemote || authoritative.isEmpty()) {
                PunDataLoader.forceLoadBundled(authoritative);
                Puns.debugMessage("Using bundled puns.json, size=" + authoritative.size());
            } else {
                Puns.debugMessage("Using remote puns.json, size=" + authoritative.size());
            }
        }
        if (CUSTOM_FILE.exists()) {
            PunDataLoader.loadLocalPuns(CUSTOM_FILE, custom);
            Puns.debugMessage("Loaded custom_puns.json, size=" + custom.size());
        }
        ACTIVE_PUNS = PunDataLoader.reindex(authoritative, custom);
    }

    public static List<PunEntry> reindex(List<PunEntry> authoritative, List<PunEntry> custom) {
        ArrayList<PunEntry> reindexed = new ArrayList<PunEntry>(authoritative);
        int id = authoritative.size();
        for (PunEntry c : custom) {
            reindexed.add(new PunEntry(id++, c.question(), c.answer()));
        }
        return reindexed;
    }

    public static void addCustomPun(String question, String answer) {
        int nextId = ACTIVE_PUNS.size();
        PunEntry newPun = new PunEntry(nextId, question, answer);
        ArrayList<PunEntry> custom = new ArrayList<PunEntry>();
        if (CUSTOM_FILE.exists()) {
            PunDataLoader.loadLocalPuns(CUSTOM_FILE, custom);
        }
        custom.add(newPun);
        PunDataLoader.saveLocalPuns(CUSTOM_FILE, custom);
        PunDataLoader.loadPuns();
        Puns.debugMessage("Added custom pun: " + question + " -> " + answer);
    }

    public static boolean removeCustomPun(int id) {
        boolean removed;
        ArrayList<PunEntry> custom = new ArrayList<PunEntry>();
        if (CUSTOM_FILE.exists()) {
            PunDataLoader.loadLocalPuns(CUSTOM_FILE, custom);
        }
        if (removed = custom.removeIf(p -> p.id() == id)) {
            PunDataLoader.saveLocalPuns(CUSTOM_FILE, custom);
            PunDataLoader.loadPuns();
            Puns.debugMessage("Removed custom pun with ID: " + id);
        }
        return removed;
    }

    public static void receiveSyncedPuns(List<PunEntry> synced) {
        if (synced == null || synced.isEmpty()) {
            PunDataLoader.loadPuns();
            SYNCED_PUNS = new ArrayList<PunEntry>(ACTIVE_PUNS);
            Puns.warnMessage("Received empty pun list from server, falling back; SYNCED_PUNS size=" + SYNCED_PUNS.size());
        } else {
            ACTIVE_PUNS.clear();
            ACTIVE_PUNS.addAll(synced);
            SYNCED_PUNS = new ArrayList<PunEntry>(synced);
            Puns.debugMessage("Received synced puns from server: " + SYNCED_PUNS.size());
        }
    }

    public static PunEntry getPun(int id) {
        List<PunEntry> puns = PunDataLoader.getPuns();
        if (puns == null || puns.isEmpty()) {
            return null;
        }
        if (id < 0 || id >= puns.size()) {
            return null;
        }
        return puns.get(id);
    }

    public static List<PunEntry> getPuns() {
        if (SYNCED_PUNS != null && !SYNCED_PUNS.isEmpty()) {
            return SYNCED_PUNS;
        }
        if (ACTIVE_PUNS != null && !ACTIVE_PUNS.isEmpty()) {
            return ACTIVE_PUNS;
        }
        PunDataLoader.loadPuns();
        return new ArrayList<PunEntry>(ACTIVE_PUNS);
    }

    public static PunEntry getRandomPun(RandomSource random) {
        List<PunEntry> activePuns = PunDataLoader.getPuns();
        if (activePuns.isEmpty()) {
            return null;
        }
        return activePuns.get(random.m_188503_(activePuns.size()));
    }

    public static void forceLoadBundled(List<PunEntry> target) {
        target.clear();
        try (InputStreamReader reader = new InputStreamReader(PunDataLoader.class.getResourceAsStream("/data/puns/puns/puns.json"), StandardCharsets.UTF_8);){
            JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            if (root != null && root.isJsonArray()) {
                for (JsonElement element : root.getAsJsonArray()) {
                    PunEntry entry = (PunEntry)GSON.fromJson(element, PunEntry.class);
                    if (entry == null) continue;
                    target.add(entry);
                }
            }
            Puns.debugMessage("Loaded bundled puns.json, size=" + target.size());
        }
        catch (Exception e) {
            Puns.LOGGER.error("Failed to load bundled puns.json!", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadFromUrl(String url, List<PunEntry> target) {
        try {
            HttpURLConnection conn = (HttpURLConnection)URI.create(url).toURL().openConnection();
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(3000);
            try (InputStreamReader reader = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);){
                boolean isEmpty;
                JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                if (root == null) {
                    boolean bl = false;
                    return bl;
                }
                target.clear();
                if (root.isJsonArray()) {
                    for (JsonElement element : root.getAsJsonArray()) {
                        PunEntry entry = (PunEntry)GSON.fromJson(element, PunEntry.class);
                        if (entry == null) continue;
                        target.add(entry);
                    }
                }
                if (!(isEmpty = target.isEmpty())) {
                    REMOTE_PUNS.addAll(target);
                }
                Puns.debugMessage("Loaded puns from remote URL: " + url + ", size=" + target.size());
                boolean bl = !isEmpty;
                return bl;
            }
        }
        catch (Exception e) {
            Puns.warnMessage("Failed to fetch puns from " + url, e);
            return false;
        }
    }

    public static void loadLocalPuns(File file, List<PunEntry> target) {
        target.clear();
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Type type = new TypeToken<List<PunEntry>>(){}.getType();
                List loaded = (List)GSON.fromJson((Reader)reader, type);
                if (loaded != null) {
                    target.addAll(loaded);
                }
                Puns.debugMessage("Loaded " + file.getName() + ", size=" + target.size());
            }
            catch (IOException e) {
                Puns.LOGGER.error("Failed to load " + file.getName(), (Throwable)e);
            }
        }
    }

    public static void saveLocalPuns(File file, List<PunEntry> puns) {
        try {
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson(puns, (Appendable)writer);
                Puns.debugMessage("Saved " + file.getName() + " to " + file.getPath());
            }
        }
        catch (IOException e) {
            Puns.LOGGER.error("Failed to save " + file.getName(), (Throwable)e);
        }
    }

    public static boolean deleteAuthoritativeFile() {
        try {
            Path path = PUNS_FILE.toPath();
            if (Files.exists(path, new LinkOption[0])) {
                Files.delete(path);
                Puns.debugMessage("Deleted puns.json at " + String.valueOf(path));
            } else {
                Puns.debugMessage("No puns.json found to delete at " + String.valueOf(path));
            }
            PunDataLoader.reloadPuns();
            return true;
        }
        catch (IOException e) {
            Puns.LOGGER.error("Failed to delete puns.json", (Throwable)e);
            return false;
        }
    }

    public static boolean clearAuthoritativeFile() {
        try {
            Path path = PUNS_FILE.toPath();
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)"[]", StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Puns.debugMessage("Cleared puns.json at " + String.valueOf(path));
            PunDataLoader.reloadPuns();
            return true;
        }
        catch (IOException e) {
            Puns.LOGGER.error("Failed to clear puns.json", (Throwable)e);
            return false;
        }
    }

    public static boolean clearAllCustomPuns() {
        try {
            Files.createDirectories(CUSTOM_FILE.toPath().getParent(), new FileAttribute[0]);
            Files.writeString(CUSTOM_FILE.toPath(), (CharSequence)"[]", StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Puns.debugMessage("Cleared all custom puns at " + CUSTOM_FILE.getPath());
            PunDataLoader.reloadPuns();
            return true;
        }
        catch (IOException e) {
            Puns.LOGGER.error("Failed to clear custom_puns.json", (Throwable)e);
            return false;
        }
    }

    public record PunEntry(int id, String question, String answer) {
    }
}

