/*
 * Decompiled with CFR 0.152.
 */
package puns.network;

import puns.Puns;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.data.ReactionType;
import puns.network.IPunStats;
import puns.network.LocalPunStats;
import puns.network.PunStats;

public class HybridPunStatsHandler
implements IPunStats {
    public final LocalPunStats local = new LocalPunStats();
    public final PunStats remote = new PunStats();

    @Override
    public void addReaction(PunDataLoader.PunEntry pun, ReactionType reaction) {
        if (pun != null) {
            this.delegate(pun).addReaction(pun, reaction);
        }
    }

    @Override
    public void asyncFetchStats(PunDataLoader.PunEntry pun) {
        try {
            this.delegate(pun).asyncFetchStats(pun);
        }
        catch (NumberFormatException e) {
            Puns.LOGGER.warn("Invalid punId for asyncFetchStats: " + pun.id());
            return;
        }
    }

    @Override
    public int getApprovalRating(PunDataLoader.PunEntry pun) {
        return this.delegate(pun).getApprovalRating(pun);
    }

    @Override
    public int getPositivePoints(PunDataLoader.PunEntry pun) {
        return this.delegate(pun).getPositivePoints(pun);
    }

    @Override
    public int getNegativePoints(PunDataLoader.PunEntry pun) {
        return this.delegate(pun).getNegativePoints(pun);
    }

    @Override
    public int getStatsCount(PunDataLoader.PunEntry pun) {
        return this.delegate(pun).getStatsCount(pun);
    }

    public IPunStats delegate(PunDataLoader.PunEntry pun) {
        return (Boolean)Config.COMMON.enableOnline.get() == false || !PunDataLoader.matchesRemotePun(pun) ? this.local : this.remote;
    }
}

