/*
 * Decompiled with CFR 0.152.
 */
package puns.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.fml.loading.FMLPaths;
import puns.Puns;
import puns.data.PunDataLoader;
import puns.data.ReactionType;
import puns.network.IPunStats;

public class LocalPunStats
implements IPunStats {
    public static final File STATS_FILE = FMLPaths.GAMEDIR.get().resolve("puns/local_stats.json").toFile();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Map<Integer, StatsCache> LOCAL_STATS = new ConcurrentHashMap<Integer, StatsCache>();

    public LocalPunStats() {
        this.loadLocalStats();
    }

    public synchronized void loadLocalStats() {
        if (!STATS_FILE.exists()) {
            Puns.LOGGER.info("local_stats.json not found - will be created on first reaction");
            return;
        }
        try (FileReader reader = new FileReader(STATS_FILE);){
            Type type = new TypeToken<Map<Integer, StatsCache>>(){}.getType();
            Map loaded = (Map)GSON.fromJson((Reader)reader, type);
            if (loaded != null) {
                LOCAL_STATS.putAll(loaded);
            }
            Puns.LOGGER.info("Loaded local_stats.json with {} entries", (Object)(loaded == null ? 0 : loaded.size()));
        }
        catch (Exception e) {
            Puns.LOGGER.error("Failed to load local_stats.json", (Throwable)e);
        }
    }

    @Override
    public void addReaction(PunDataLoader.PunEntry pun, ReactionType reaction) {
        if (pun == null) {
            Puns.LOGGER.warn("LocalPunStats.addReaction called with invalid pun: {}", (Object)pun);
            return;
        }
        Puns.LOGGER.info("Local reaction: punId={} reaction={}", (Object)pun.id(), (Object)reaction);
        StatsCache stats = LOCAL_STATS.computeIfAbsent(pun.id(), k -> new StatsCache());
        int points = reaction.getPoints();
        if (points > 0) {
            stats.positivePoints += points;
        } else if (points < 0) {
            stats.negativePoints += Math.abs(points);
        }
        ++stats.count;
        stats.approvalRating = stats.positivePoints + stats.negativePoints == 0 ? 0 : (int)((long)stats.positivePoints * 100L / (long)(stats.positivePoints + stats.negativePoints));
        stats.lastFetched = System.currentTimeMillis();
        this.saveLocalStats();
    }

    public synchronized void saveLocalStats() {
        try {
            Files.createDirectories(STATS_FILE.toPath().getParent(), new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(STATS_FILE);){
                GSON.toJson(LOCAL_STATS, (Appendable)writer);
            }
        }
        catch (Exception e) {
            Puns.LOGGER.error("Failed to save local_stats.json", (Throwable)e);
            e.printStackTrace();
        }
    }

    public int calculateApproval(int pos, int neg, int count) {
        if (count == 0) {
            return 0;
        }
        int total = pos + neg;
        return total == 0 ? 0 : (int)((double)pos * 100.0 / (double)total);
    }

    @Override
    public int getApprovalRating(PunDataLoader.PunEntry pun) {
        return this.getCached((PunDataLoader.PunEntry)pun).approvalRating;
    }

    @Override
    public int getPositivePoints(PunDataLoader.PunEntry pun) {
        return this.getCached((PunDataLoader.PunEntry)pun).positivePoints;
    }

    @Override
    public int getNegativePoints(PunDataLoader.PunEntry pun) {
        return this.getCached((PunDataLoader.PunEntry)pun).negativePoints;
    }

    @Override
    public int getStatsCount(PunDataLoader.PunEntry pun) {
        return this.getCached((PunDataLoader.PunEntry)pun).count;
    }

    public StatsCache getCached(PunDataLoader.PunEntry pun) {
        return LOCAL_STATS.computeIfAbsent(pun.id(), k -> new StatsCache());
    }

    @Override
    public void asyncFetchStats(PunDataLoader.PunEntry pun) {
        StatsCache s = this.getCached(pun);
        s.lastFetched = System.currentTimeMillis();
    }

    public static class StatsCache {
        public int positivePoints = 0;
        public int negativePoints = 0;
        public int approvalRating = 0;
        public int count = 0;
        public long lastFetched = 0L;
    }
}

