/*
 * Decompiled with CFR 0.152.
 */
package puns.network;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import puns.Puns;
import puns.data.PunDataLoader;
import puns.data.ReactionType;
import puns.network.IPunStats;
import puns.network.PacketHandler;
import puns.network.PunPackets;

public class NetworkedPunStats
implements IPunStats {
    public static final Map<Integer, StatsCache> GLOBAL_CACHE = new ConcurrentHashMap<Integer, StatsCache>();
    public static final long CACHE_TTL_MS = 10000L;

    public static void updateCacheFromResponse(PunDataLoader.PunEntry pun, int pos, int neg, int app, int cnt) {
        StatsCache sc = new StatsCache();
        sc.positivePoints = pos;
        sc.negativePoints = neg;
        sc.approvalRating = app;
        sc.count = cnt;
        sc.lastFetched = System.currentTimeMillis();
        GLOBAL_CACHE.put(pun.id(), sc);
    }

    public StatsCache fetchStatsIfNeeded(PunDataLoader.PunEntry pun) {
        StatsCache stats = GLOBAL_CACHE.get(pun.id());
        long now = System.currentTimeMillis();
        if (stats == null || now - stats.lastFetched > 10000L) {
            this.asyncFetchStats(pun);
            if (stats == null) {
                stats = new StatsCache();
                GLOBAL_CACHE.put(pun.id(), stats);
            }
        }
        return stats;
    }

    @Override
    public void addReaction(PunDataLoader.PunEntry pun, ReactionType reaction) {
        int id = pun.id();
        StatsCache cache = GLOBAL_CACHE.computeIfAbsent(id, k -> new StatsCache());
        ++cache.count;
        if (reaction.getPoints() > 0) {
            cache.positivePoints += reaction.getPoints();
        } else if (reaction.getPoints() < 0) {
            cache.negativePoints += -reaction.getPoints();
        }
        int total = cache.positivePoints + cache.negativePoints;
        cache.approvalRating = total == 0 ? 0 : (int)((float)cache.positivePoints * 100.0f / (float)total);
        cache.lastFetched = System.currentTimeMillis();
        PacketHandler.INSTANCE.sendToServer((Object)new PunPackets.SendReactionPayload(pun, reaction.name()));
    }

    @Override
    public void asyncFetchStats(PunDataLoader.PunEntry pun) {
        int id = pun.id();
        try {
            PacketHandler.INSTANCE.sendToServer((Object)new PunPackets.FetchStatsPayload(pun));
            GLOBAL_CACHE.computeIfAbsent(id, k -> new StatsCache());
            Puns.debugMessage("Fetching fresh stats for pun: " + id);
        }
        catch (Exception e) {
            Puns.LOGGER.warn("Failed to send FetchStatsPayload for " + id, (Throwable)e);
        }
    }

    public StatsCache getCached(PunDataLoader.PunEntry pun) {
        int id = pun.id();
        StatsCache stats = GLOBAL_CACHE.get(id);
        long now = System.currentTimeMillis();
        if (stats == null) {
            stats = new StatsCache();
            GLOBAL_CACHE.put(id, stats);
            this.asyncFetchStats(pun);
            return stats;
        }
        if (now - stats.lastFetched > 10000L) {
            this.asyncFetchStats(pun);
        }
        return stats;
    }

    @Override
    public int getApprovalRating(PunDataLoader.PunEntry pun) {
        return this.getCached((PunDataLoader.PunEntry)pun).approvalRating;
    }

    @Override
    public int getPositivePoints(PunDataLoader.PunEntry pun) {
        return this.getCached((PunDataLoader.PunEntry)pun).positivePoints;
    }

    @Override
    public int getNegativePoints(PunDataLoader.PunEntry pun) {
        return this.getCached((PunDataLoader.PunEntry)pun).negativePoints;
    }

    @Override
    public int getStatsCount(PunDataLoader.PunEntry pun) {
        return this.getCached((PunDataLoader.PunEntry)pun).count;
    }

    public static class StatsCache {
        public int positivePoints = 0;
        public int negativePoints = 0;
        public int approvalRating = 0;
        public int count = 0;
        public long lastFetched = 0L;
    }
}

