/*
 * Decompiled with CFR 0.152.
 */
package puns.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import puns.Puns;
import puns.client.ClientPacketHandler;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.data.ReactionType;
import puns.network.NetworkedPunStats;
import puns.network.PacketHandler;

public class PunPackets {
    private static void encodePunEntry(PunDataLoader.PunEntry entry, FriendlyByteBuf buf) {
        buf.writeInt(entry.id());
        buf.m_130070_(entry.question());
        buf.m_130070_(entry.answer());
    }

    private static PunDataLoader.PunEntry decodePunEntry(FriendlyByteBuf buf) {
        return new PunDataLoader.PunEntry(buf.readInt(), buf.m_130277_(), buf.m_130277_());
    }

    public record OpenVoteScreenPayload(PunDataLoader.PunEntry pun) {
        public static void encode(OpenVoteScreenPayload msg, FriendlyByteBuf buf) {
            PunPackets.encodePunEntry(msg.pun, buf);
        }

        public static OpenVoteScreenPayload decode(FriendlyByteBuf buf) {
            return new OpenVoteScreenPayload(PunPackets.decodePunEntry(buf));
        }

        public static void handle(OpenVoteScreenPayload msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> ClientPacketHandler.openVoteScreen(msg.pun));
            ctx.get().setPacketHandled(true);
        }
    }

    public record ListPunsPayload(List<PunDataLoader.PunEntry> puns) {
        public static void encode(ListPunsPayload msg, FriendlyByteBuf buf) {
            buf.writeInt(msg.puns.size());
            for (PunDataLoader.PunEntry e : msg.puns) {
                PunPackets.encodePunEntry(e, buf);
            }
        }

        public static ListPunsPayload decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<PunDataLoader.PunEntry> list = new ArrayList<PunDataLoader.PunEntry>(size);
            for (int i = 0; i < size; ++i) {
                list.add(PunPackets.decodePunEntry(buf));
            }
            return new ListPunsPayload(list);
        }

        public static void handle(ListPunsPayload msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Puns.LOGGER.info("Client Active Puns ({})", (Object)msg.puns.size());
                for (PunDataLoader.PunEntry e : msg.puns) {
                    Puns.LOGGER.info("[ID: {}] {} -> {}", new Object[]{e.id(), e.question(), e.answer()});
                }
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && FMLEnvironment.dist == Dist.CLIENT) {
                    player.m_213846_((Component)Component.m_237113_((String)("List of " + msg.puns.size() + " puns printed to log.")));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public record SyncPunsPayload(List<PunDataLoader.PunEntry> puns) {
        public static void encode(SyncPunsPayload msg, FriendlyByteBuf buf) {
            buf.writeInt(msg.puns.size());
            for (PunDataLoader.PunEntry e : msg.puns) {
                PunPackets.encodePunEntry(e, buf);
            }
        }

        public static SyncPunsPayload decode(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<PunDataLoader.PunEntry> list = new ArrayList<PunDataLoader.PunEntry>(size);
            for (int i = 0; i < size; ++i) {
                list.add(PunPackets.decodePunEntry(buf));
            }
            return new SyncPunsPayload(list);
        }

        public static void handle(SyncPunsPayload msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> PunDataLoader.receiveSyncedPuns(msg.puns));
            ctx.get().setPacketHandled(true);
        }
    }

    public record FetchStatsPayload(PunDataLoader.PunEntry pun) {
        public static void encode(FetchStatsPayload msg, FriendlyByteBuf buf) {
            PunPackets.encodePunEntry(msg.pun, buf);
        }

        public static FetchStatsPayload decode(FriendlyByteBuf buf) {
            return new FetchStatsPayload(PunPackets.decodePunEntry(buf));
        }

        public static void handle(FetchStatsPayload msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null || Puns.SERVER_PUN_STATS_HANDLER == null) {
                    return;
                }
                int pos = Puns.SERVER_PUN_STATS_HANDLER.getPositivePoints(msg.pun);
                int neg = Puns.SERVER_PUN_STATS_HANDLER.getNegativePoints(msg.pun);
                int app = Puns.SERVER_PUN_STATS_HANDLER.getApprovalRating(msg.pun);
                int cnt = Puns.SERVER_PUN_STATS_HANDLER.getStatsCount(msg.pun);
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new StatsResponsePayload(msg.pun, pos, neg, app, cnt));
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public record SendReactionPayload(PunDataLoader.PunEntry pun, String reaction) {
        public static void encode(SendReactionPayload msg, FriendlyByteBuf buf) {
            PunPackets.encodePunEntry(msg.pun, buf);
            buf.m_130070_(msg.reaction);
        }

        public static SendReactionPayload decode(FriendlyByteBuf buf) {
            return new SendReactionPayload(PunPackets.decodePunEntry(buf), buf.m_130277_());
        }

        public static void handle(SendReactionPayload msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null || Puns.SERVER_PUN_STATS_HANDLER == null) {
                    return;
                }
                try {
                    ReactionType rt = ReactionType.valueOf(msg.reaction);
                    Puns.SERVER_PUN_STATS_HANDLER.addReaction(msg.pun, rt);
                    int pos = Puns.SERVER_PUN_STATS_HANDLER.getPositivePoints(msg.pun);
                    int neg = Puns.SERVER_PUN_STATS_HANDLER.getNegativePoints(msg.pun);
                    int app = Puns.SERVER_PUN_STATS_HANDLER.getApprovalRating(msg.pun);
                    int cnt = Puns.SERVER_PUN_STATS_HANDLER.getStatsCount(msg.pun);
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new StatsResponsePayload(msg.pun, pos, neg, app, cnt));
                }
                catch (IllegalArgumentException e) {
                    Puns.LOGGER.warn("Invalid reaction from {}: {}", (Object)player.m_7755_().getString(), (Object)msg.reaction);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public record StatsResponsePayload(PunDataLoader.PunEntry pun, int positivePoints, int negativePoints, int approvalRating, int count) {
        public static void encode(StatsResponsePayload msg, FriendlyByteBuf buf) {
            PunPackets.encodePunEntry(msg.pun, buf);
            buf.writeInt(msg.positivePoints);
            buf.writeInt(msg.negativePoints);
            buf.writeInt(msg.approvalRating);
            buf.writeInt(msg.count);
        }

        public static StatsResponsePayload decode(FriendlyByteBuf buf) {
            return new StatsResponsePayload(PunPackets.decodePunEntry(buf), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
        }

        public static void handle(StatsResponsePayload msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> NetworkedPunStats.updateCacheFromResponse(msg.pun, msg.positivePoints, msg.negativePoints, msg.approvalRating, msg.count));
            ctx.get().setPacketHandled(true);
        }
    }

    public record SyncConfigPayload(boolean enableLocalStats, boolean enableOnline) {
        public static void encode(SyncConfigPayload msg, FriendlyByteBuf buf) {
            buf.writeBoolean(msg.enableLocalStats);
            buf.writeBoolean(msg.enableOnline);
        }

        public static SyncConfigPayload decode(FriendlyByteBuf buf) {
            return new SyncConfigPayload(buf.readBoolean(), buf.readBoolean());
        }

        public static void handle(SyncConfigPayload msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Config.COMMON.enableLocalStats.set((Object)msg.enableLocalStats);
                Config.COMMON.enableOnline.set((Object)msg.enableOnline);
                ClientPacketHandler.applyServerConfig(msg.enableLocalStats, msg.enableOnline);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

