/*
 * Decompiled with CFR 0.152.
 */
package puns.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import puns.Puns;
import puns.config.Config;
import puns.data.PunDataLoader;
import puns.data.ReactionType;
import puns.network.IPunStats;

public class PunStats
implements IPunStats {
    private static final String SERVER_URL = "http://158.178.157.217:5000/api";
    private static final Gson GSON = new Gson();
    public static final Map<PunDataLoader.PunEntry, StatsCache> CACHE = new ConcurrentHashMap<PunDataLoader.PunEntry, StatsCache>();
    public static final long CACHE_TTL_MS = 10000L;

    @Override
    public void addReaction(PunDataLoader.PunEntry pun, ReactionType reaction) {
        if (!((Boolean)Config.COMMON.enableOnline.get()).booleanValue()) {
            return;
        }
        new Thread(() -> {
            Puns.debugMessage("Sending reaction: pun=" + pun.id() + ", reaction=" + reaction.name());
            this.sendReactionToServer(pun, reaction);
            StatsCache updated = this.fetchStatsFromServer(pun);
            Puns.debugMessage("Updated stats after reaction for pun=" + pun.id() + " [pos=" + updated.positivePoints + ", neg=" + updated.negativePoints + ", approval=" + updated.approvalRating + ", count=" + updated.count + "]");
            CACHE.put(pun, updated);
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReactionToServer(PunDataLoader.PunEntry pun, ReactionType reaction) {
        HttpURLConnection conn = null;
        try {
            String body;
            StringBuilder sb;
            BufferedReader br;
            conn = (HttpURLConnection)URI.create("http://158.178.157.217:5000/api/reaction").toURL().openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            conn.setConnectTimeout(4000);
            conn.setReadTimeout(6000);
            JsonObject payload = new JsonObject();
            payload.addProperty("pun_id", (Number)pun.id());
            payload.addProperty("reaction", reaction.name());
            String json = GSON.toJson((JsonElement)payload);
            Puns.debugMessage("POST /reaction payload: " + json);
            try (OutputStream os = conn.getOutputStream();){
                os.write(json.getBytes(StandardCharsets.UTF_8));
                os.flush();
            }
            int status = conn.getResponseCode();
            Puns.debugMessage("POST /reaction status=" + status);
            if (status >= 200 && status < 300) {
                br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                try {
                    String line;
                    sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    body = sb.toString();
                }
                finally {
                    br.close();
                }
            }
            br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));
            try {
                String line;
                sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                body = sb.toString();
            }
            finally {
                br.close();
            }
            Puns.debugMessage("POST /reaction body: " + body);
            if (status >= 200 && status < 300) {
                JsonObject response = (JsonObject)GSON.fromJson(body, JsonObject.class);
                StatsCache updated = this.updateCacheFromResponse(pun, response);
                Puns.debugMessage("Server returned stats after reaction for pun=" + pun.id() + " [pos=" + updated.positivePoints + ", neg=" + updated.negativePoints + ", approval=" + updated.approvalRating + ", count=" + updated.count + "]");
            } else {
                Puns.LOGGER.warn("Reaction POST failed for pun=" + pun.id() + " with status " + status + " and body: " + body);
            }
        }
        catch (Exception e) {
            Puns.LOGGER.error("Error sending reaction for pun=" + pun.id() + ", reaction=" + reaction.name(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public int getApprovalRating(PunDataLoader.PunEntry pun) {
        StatsCache stats = this.fetchStatsIfNeeded(pun);
        return stats.approvalRating;
    }

    @Override
    public int getPositivePoints(PunDataLoader.PunEntry pun) {
        StatsCache stats = this.fetchStatsIfNeeded(pun);
        return stats.positivePoints;
    }

    @Override
    public int getNegativePoints(PunDataLoader.PunEntry pun) {
        StatsCache stats = this.fetchStatsIfNeeded(pun);
        return stats.negativePoints;
    }

    @Override
    public int getStatsCount(PunDataLoader.PunEntry pun) {
        StatsCache stats = this.fetchStatsIfNeeded(pun);
        return stats.count;
    }

    private StatsCache fetchStatsIfNeeded(PunDataLoader.PunEntry pun) {
        StatsCache stats = CACHE.get(pun);
        if (((Boolean)Config.COMMON.enableOnline.get()).booleanValue()) {
            long now = System.currentTimeMillis();
            if (stats == null || now - stats.lastFetched > 10000L) {
                this.asyncFetchStats(pun);
            }
        }
        if (stats == null) {
            stats = new StatsCache();
            stats.positivePoints = 0;
            stats.negativePoints = 0;
            stats.approvalRating = 0;
            stats.count = 0;
            stats.lastFetched = System.currentTimeMillis();
            CACHE.put(pun, stats);
        }
        return stats;
    }

    @Override
    public void asyncFetchStats(PunDataLoader.PunEntry pun) {
        try {
            new Thread(() -> {
                StatsCache stats = this.fetchStatsFromServer(pun);
                Map<PunDataLoader.PunEntry, StatsCache> map = CACHE;
                synchronized (map) {
                    CACHE.put(pun, stats);
                }
                Puns.debugMessage("Async stats fetch complete for pun=" + pun.id());
            }, "PunStatsFetcher").start();
        }
        catch (NumberFormatException e) {
            Puns.LOGGER.warn("Invalid pun for asyncFetchStats: " + pun.id());
            return;
        }
    }

    public StatsCache fetchStatsFromServer(PunDataLoader.PunEntry pun) {
        StatsCache stats = new StatsCache();
        try {
            HttpURLConnection conn = (HttpURLConnection)URI.create("http://158.178.157.217:5000/api/stats/" + pun.id()).toURL().openConnection();
            conn.setRequestMethod("GET");
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                JsonObject response = (JsonObject)GSON.fromJson((Reader)br, JsonObject.class);
                stats = this.updateCacheFromResponse(pun, response);
            }
            conn.disconnect();
        }
        catch (Exception e) {
            Puns.LOGGER.error("Error fetching stats for pun=" + pun.id(), (Throwable)e);
        }
        return stats;
    }

    private StatsCache updateCacheFromResponse(PunDataLoader.PunEntry pun, JsonObject response) {
        StatsCache stats = new StatsCache();
        if (response.has("positive_points")) {
            stats.positivePoints = response.get("positive_points").getAsInt();
        }
        if (response.has("negative_points")) {
            stats.negativePoints = response.get("negative_points").getAsInt();
        }
        if (response.has("approval_rating")) {
            stats.approvalRating = response.get("approval_rating").getAsInt();
        }
        if (response.has("count")) {
            stats.count = response.get("count").getAsInt();
        }
        stats.lastFetched = System.currentTimeMillis();
        Puns.debugMessage("Updated cache for pun=" + pun.id() + " [pos=" + stats.positivePoints + ", neg=" + stats.negativePoints + ", approval=" + stats.approvalRating + ", count=" + stats.count + "]");
        CACHE.put(pun, stats);
        return stats;
    }

    public static class StatsCache {
        public int positivePoints = 0;
        public int negativePoints = 0;
        public int approvalRating = 0;
        public int count = 0;
        public long lastFetched = 0L;
    }
}

