package net.fawnoculus.nochat.commands;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fawnoculus.nochat.RemoveChatConfig;
import net.fawnoculus.nochat.util.config.options.BooleanOption;
import net.fawnoculus.nochat.util.config.options.Option;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemoveChatCommands {
  public static void initialize() {
    CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
      dispatcher.register(class_2170.method_9247("remove_chat")
          .requires(source -> source.method_9259(1))
          .then(class_2170.method_9247("disable_chat")
              .executes(context -> getOptionInfo(context, RemoveChatConfig.DISABLE_CHAT))
              .then(class_2170.method_9244("boolean", BoolArgumentType.bool())
                  .executes(context -> setBoolOption(context, RemoveChatConfig.DISABLE_CHAT))
              )
          )
          .then(class_2170.method_9247("disable_msg_commands")
              .executes(context -> getOptionInfo(context, RemoveChatConfig.DISABLE_MSG_COMMANDS))
              .then(class_2170.method_9244("boolean", BoolArgumentType.bool())
                  .executes(context -> setBoolOption(context, RemoveChatConfig.DISABLE_MSG_COMMANDS))
              )
          )
          .then(class_2170.method_9247("disable_teammsg")
              .executes(context -> getOptionInfo(context, RemoveChatConfig.DISABLE_TEAM_MSG))
              .then(class_2170.method_9244("boolean", BoolArgumentType.bool())
                  .executes(context -> setBoolOption(context, RemoveChatConfig.DISABLE_TEAM_MSG))
              )
          )
          .then(class_2170.method_9247("exclude_ops")
              .executes(context -> getOptionInfo(context, RemoveChatConfig.EXCLUDE_OPS))
              .then(class_2170.method_9244("boolean", BoolArgumentType.bool())
                  .executes(context -> setBoolOption(context, RemoveChatConfig.EXCLUDE_OPS))
              )
          )
          .then(class_2170.method_9247("excluded_players")
              .executes(context -> getOptionInfo(context, RemoveChatConfig.EXCLUDED_PLAYERS))
              .then(class_2170.method_9247("add")
                  .then(class_2170.method_9244("players", class_2186.method_9308())
                      .executes(RemoveChatCommands::addExcludedPlayer))
              )
              .then(class_2170.method_9247("remove")
                  .then(class_2170.method_9244("players", class_2186.method_9308())
                      .executes(RemoveChatCommands::removeExcludedPlayer))
              )
              .then(class_2170.method_9247("list")
                  .executes(RemoveChatCommands::listExcludedPlayer)
              )
          )
      );
    });
  }
  
  public static int getOptionInfo(CommandContext<class_2168> context, Option<?> option){
    context.getSource().method_9226(() -> class_2561.method_43470(option.COMMENT), false);
    return 1;
  }
  public static int setBoolOption(CommandContext<class_2168> context, BooleanOption option){
    Boolean value = context.getArgument("boolean", Boolean.class);
    option.setValue(value);
    RemoveChatConfig.CONFIG_FILE.writeFile();
    context.getSource().method_9226(() -> class_2561.method_43470("Set Option " + option.NAME + " to '" + value + "'"), true);
    return 1;
  }
  public static int addExcludedPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
    Collection<class_3222> players = class_2186.method_9312(context, "players");
    List<String> playerNames = new ArrayList<>(RemoveChatConfig.EXCLUDED_PLAYERS.getValue());
    for(class_3222 player : players){
      playerNames.add(player.method_5477().method_54160());
    }
    RemoveChatConfig.EXCLUDED_PLAYERS.setValue(playerNames);
    RemoveChatConfig.CONFIG_FILE.writeFile();
    context.getSource().method_9226(() -> class_2561.method_43470("Added " + players.size() + " Players to Excluded Player List"), true);
    return 1;
  }
  public static int removeExcludedPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
    Collection<class_3222> players = class_2186.method_9312(context, "players");
    List<String> playerNames = new ArrayList<>(RemoveChatConfig.EXCLUDED_PLAYERS.getValue());
    for(class_3222 player : players){
      playerNames.remove(player.method_5477().method_54160());
    }
    RemoveChatConfig.EXCLUDED_PLAYERS.setValue(playerNames);
    RemoveChatConfig.CONFIG_FILE.writeFile();
    context.getSource().method_9226(() -> class_2561.method_43470("Removed " + players.size() + " Players from Excluded Player List"), true);
    return 1;
  }
  public static int listExcludedPlayer(CommandContext<class_2168> context){
    class_2168 source = context.getSource();
    List<String> playerNames = RemoveChatConfig.EXCLUDED_PLAYERS.getValue();
    source.method_9226(() -> class_2561.method_43470("There are currently " + playerNames.size() + " Excluded Players:"), false);
    for(String name : playerNames){
      source.method_9226(() -> class_2561.method_43470(name).method_27692(class_124.field_1080), false);
    }
    return 1;
  }
}
