package net.fawnoculus.nochat.mixin;

import net.fawnoculus.nochat.RemoveChatConfig;
import net.minecraft.class_124;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7471;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Predicate;

@Mixin(class_3324.class)
public abstract class PlayerManagerMixin {
  
  @Inject(method = "broadcast(" +
      "Lnet/minecraft/network/message/SignedMessage;" +
      "Ljava/util/function/Predicate;" +
      "Lnet/minecraft/server/network/ServerPlayerEntity;" +
      "Lnet/minecraft/network/message/MessageType$Parameters;" +
      ")V"
      , at = @At("HEAD")
      , cancellable = true)
  private void init(class_7471 message, Predicate<class_3222> shouldSendFiltered, @Nullable class_3222 sender, class_2556.class_7602 params, CallbackInfo ci) {
    // Only Cancel Messages send by Players
    if (RemoveChatConfig.DISABLE_CHAT.getValue() && sender != null && RemoveChatConfig.playerNotExcluded(sender)) {
      sender.method_64398(class_2561.method_43470("The Chat is currently Disabled").method_27692(class_124.field_1061));
      ci.cancel();
    }
  }
}