/*
 * Decompiled with CFR 0.152.
 */
package net.fawnoculus.nochat.util.config;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fawnoculus.nochat.util.ExceptionUtil;
import net.fawnoculus.nochat.util.config.ConfigFileType;
import net.fawnoculus.nochat.util.config.options.BooleanOption;
import net.fawnoculus.nochat.util.config.options.DoubleOption;
import net.fawnoculus.nochat.util.config.options.FloatOption;
import net.fawnoculus.nochat.util.config.options.IntegerOption;
import net.fawnoculus.nochat.util.config.options.Option;
import net.fawnoculus.nochat.util.config.options.StringListOption;
import net.fawnoculus.nochat.util.config.options.StringOption;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFile {
    public final Logger LOGGER;
    public final File CONFIG_FILE;
    public final ConfigFileType CONFIG_FILE_TYPE;
    public final List<String> OPTION_NAMES = new ArrayList<String>();
    public List<Option<?>> options = new ArrayList();
    public boolean initialized = false;

    public ConfigFile(String subPath, ConfigFileType configFileType, @Nullable Logger logger) {
        this(FabricLoader.getInstance().getConfigDir().resolve(subPath).toAbsolutePath(), configFileType, logger);
    }

    public ConfigFile(Path path, ConfigFileType configFileType, @Nullable Logger logger) {
        this.CONFIG_FILE_TYPE = configFileType;
        this.LOGGER = logger != null ? logger : LoggerFactory.getLogger((String)"FawnoculusConfigUtil");
        this.CONFIG_FILE = path.endsWith(configFileType.getFileExtension()) ? new File(path.toUri()) : new File(String.valueOf(path) + configFileType.getFileExtension());
    }

    public void readFile() {
        List<Option<?>> readOptions = this.options;
        try {
            readOptions = this.CONFIG_FILE_TYPE.readFile(this.CONFIG_FILE, this.LOGGER, this.options);
        }
        catch (Exception e) {
            this.LOGGER.error("Failed to read from Config File: {} \n Exception: {}", (Object)this.CONFIG_FILE.getPath(), (Object)ExceptionUtil.makePretty(e));
        }
        this.options = readOptions;
    }

    public void writeFile() {
        try {
            if (!this.CONFIG_FILE.exists()) {
                boolean ignored = this.CONFIG_FILE.getParentFile().mkdirs();
                boolean newFile = this.CONFIG_FILE.createNewFile();
                if (newFile) {
                    this.LOGGER.info("Created new Config File: {}", (Object)this.CONFIG_FILE.getPath());
                } else {
                    this.LOGGER.warn("Failed to create Config File: {}", (Object)this.CONFIG_FILE.getPath());
                }
            } else {
                boolean delete = this.CONFIG_FILE.delete();
                if (!delete) {
                    this.LOGGER.warn("Failed to delete old Config File: {}", (Object)this.CONFIG_FILE.getPath());
                }
            }
            this.CONFIG_FILE_TYPE.writeFile(this.CONFIG_FILE, this.LOGGER, this.options);
        }
        catch (Exception e) {
            this.LOGGER.error("Failed to write to Config File: {} \n Exception: {}", (Object)this.CONFIG_FILE.getPath(), (Object)ExceptionUtil.makePretty(e));
        }
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Config File already Initialized");
        }
        if (this.CONFIG_FILE.exists()) {
            this.readFile();
        }
        this.writeFile();
        this.initialized = true;
    }

    public List<Option<?>> getAllOptions() {
        return List.copyOf(this.options);
    }

    protected void addAndValidateOption(Option<?> option) {
        String name = option.NAME;
        if (!this.CONFIG_FILE_TYPE.isValidOption(option).booleanValue()) {
            throw new IllegalArgumentException("Option with name '" + name + "' is not valid for Config Type '" + this.CONFIG_FILE_TYPE.getClass().getName() + "'");
        }
        if (this.OPTION_NAMES.contains(name)) {
            throw new IllegalArgumentException("Option with name '" + name + "' already exist in Config File '" + this.CONFIG_FILE.getPath() + "'");
        }
        this.OPTION_NAMES.add(name);
        this.options.add(option);
    }

    public BooleanOption newBooleanOption(String name, Boolean defaultValue, @Nullable String comment, Option.ExtraType extraType) {
        if (comment != null) {
            comment = (String)comment + " [Default: " + defaultValue + "]";
        }
        BooleanOption option = new BooleanOption(this, name, defaultValue, (String)comment);
        option.setExtraType(extraType);
        this.addAndValidateOption(option);
        return option;
    }

    public BooleanOption newBooleanOption(String name, Boolean defaultValue, @Nullable String comment) {
        return this.newBooleanOption(name, defaultValue, comment, new Option.ExtraType.Generic());
    }

    public DoubleOption newDoubleOption(String name, Double defaultValue, @Nullable String comment, Option.ExtraType extraType) {
        if (comment != null) {
            comment = (String)comment + " [Default: " + defaultValue + "]";
        }
        DoubleOption option = new DoubleOption(this, name, defaultValue, (String)comment);
        option.setExtraType(extraType);
        this.addAndValidateOption(option);
        return option;
    }

    public DoubleOption newDoubleOption(String name, Double defaultValue, @Nullable String comment, Double min, Double max) {
        if (comment != null) {
            comment = (String)comment + "[min: " + min + "; max: " + max + "]";
        }
        return this.newDoubleOption(name, defaultValue, (String)comment, new Option.ExtraType.FloatRange(min, max));
    }

    public DoubleOption newDoubleOption(String name, Double defaultValue, @Nullable String comment) {
        return this.newDoubleOption(name, defaultValue, comment, new Option.ExtraType.Generic());
    }

    public FloatOption newFloatOption(String name, Float defaultValue, @Nullable String comment, Option.ExtraType extraType) {
        if (comment != null) {
            comment = (String)comment + " [Default: " + defaultValue + "]";
        }
        FloatOption option = new FloatOption(this, name, defaultValue, (String)comment);
        option.setExtraType(extraType);
        this.addAndValidateOption(option);
        return option;
    }

    public FloatOption newFloatOption(String name, Float defaultValue, @Nullable String comment, Float min, Float max) {
        if (comment != null) {
            comment = (String)comment + "[min: " + min + "; max: " + max + "]";
        }
        return this.newFloatOption(name, defaultValue, (String)comment, new Option.ExtraType.FloatRange(min.floatValue(), max.floatValue()));
    }

    public FloatOption newFloatOption(String name, Float defaultValue, @Nullable String comment) {
        return this.newFloatOption(name, defaultValue, comment, new Option.ExtraType.Generic());
    }

    public IntegerOption newIntegerOption(String name, Integer defaultValue, @Nullable String comment, Option.ExtraType extraType) {
        if (comment != null) {
            comment = (String)comment + " [Default: " + defaultValue + "]";
        }
        IntegerOption option = new IntegerOption(this, name, defaultValue, (String)comment);
        option.setExtraType(extraType);
        this.addAndValidateOption(option);
        return option;
    }

    public IntegerOption newIntegerOption(String name, Integer defaultValue, @Nullable String comment, Integer min, Integer max) {
        if (comment != null) {
            comment = (String)comment + "[min: " + min + "; max: " + max + "]";
        }
        return this.newIntegerOption(name, defaultValue, (String)comment, new Option.ExtraType.IntRange(min, max));
    }

    public IntegerOption newIntegerOption(String name, Integer defaultValue, @Nullable String comment) {
        return this.newIntegerOption(name, defaultValue, comment, new Option.ExtraType.Generic());
    }

    public StringOption newStringOption(String name, String defaultValue, @Nullable String comment, Option.ExtraType extraType) {
        if (comment != null) {
            comment = (String)comment + " [Default: " + defaultValue + "]";
        }
        StringOption option = new StringOption(this, name, defaultValue, (String)comment);
        option.setExtraType(extraType);
        this.addAndValidateOption(option);
        return option;
    }

    public StringOption newStringOption(String name, String defaultValue, @Nullable String comment, String ... allowedValues) {
        if (comment != null) {
            StringBuilder commentBuilder = new StringBuilder((String)comment);
            commentBuilder.append(" ");
            for (int i = 0; i < allowedValues.length - 1; ++i) {
                commentBuilder.append(allowedValues[i]).append(",");
            }
            comment = commentBuilder.toString();
            comment = (String)comment + allowedValues[allowedValues.length - 1];
            comment = (String)comment + "]";
        }
        return this.newStringOption(name, defaultValue, (String)comment, new Option.ExtraType.AllowedValues(allowedValues));
    }

    public StringOption newStringOption(String name, String defaultValue, @Nullable String comment) {
        return this.newStringOption(name, defaultValue, comment, new Option.ExtraType.Generic());
    }

    public StringListOption newStringListOption(String name, List<String> defaultValue, @Nullable String comment, Option.ExtraType extraType) {
        if (comment != null) {
            comment = (String)comment + " [Default: " + String.valueOf(defaultValue) + "]";
        }
        StringListOption option = new StringListOption(this, name, defaultValue, (String)comment);
        option.setExtraType(extraType);
        this.addAndValidateOption(option);
        return option;
    }

    public StringListOption newStringListOption(String name, List<String> defaultValue, @Nullable String comment) {
        return this.newStringListOption(name, defaultValue, comment, new Option.ExtraType.Generic());
    }
}

