/*
 * Decompiled with CFR 0.152.
 */
package net.fawnoculus.nochat.util.config.filetype;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.fawnoculus.nochat.util.ExceptionUtil;
import net.fawnoculus.nochat.util.config.ConfigFileType;
import net.fawnoculus.nochat.util.config.options.BooleanOption;
import net.fawnoculus.nochat.util.config.options.DoubleOption;
import net.fawnoculus.nochat.util.config.options.FloatOption;
import net.fawnoculus.nochat.util.config.options.IntegerOption;
import net.fawnoculus.nochat.util.config.options.Option;
import net.fawnoculus.nochat.util.config.options.StringListOption;
import net.fawnoculus.nochat.util.config.options.StringOption;
import org.slf4j.Logger;

public class JsonConfigFile
implements ConfigFileType {
    @Override
    public String getFileExtension() {
        return ".json";
    }

    @Override
    public Boolean isValidOption(Option<?> option) {
        return !this.isStringInvalid(option.NAME);
    }

    @Override
    public Boolean isValidValue(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String[].class}, (Object)object2, n)) {
            case 0: {
                String string = (String)object2;
                return !this.isStringInvalid(string);
            }
            case 1: {
                String[] strings;
                for (String string : strings = (String[])object2) {
                    if (!this.isStringInvalid(string)) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private boolean isStringInvalid(String string) {
        return string.contains("\n") || string.contains("\"");
    }

    @Override
    public List<Option<?>> readFile(File configFile, Logger LOGGER, List<Option<?>> expectedOptions) {
        JsonObject jsonObject;
        Gson gson = new Gson();
        try {
            JsonReader jsonReader = new JsonReader((Reader)new FileReader(configFile));
            jsonObject = (JsonObject)gson.fromJson(jsonReader, JsonObject.class);
            if (!jsonObject.isJsonObject()) {
                throw new JsonSyntaxException("What the hell did you do to the Json File?!");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse Json Config File '{}' \nException: {}", (Object)configFile.getPath(), (Object)ExceptionUtil.makePretty(e));
            return expectedOptions;
        }
        block22: for (Option<?> option : expectedOptions) {
            Option<?> option2;
            JsonElement readValue = jsonObject.get(option.NAME);
            if (readValue == null || !readValue.isJsonPrimitive() && !readValue.isJsonArray()) {
                LOGGER.warn("Didn't find option '{}' of type '{}' in Config File '{}', using default value", new Object[]{option.NAME, option.getClass().getName(), configFile.getPath()});
                continue;
            }
            Objects.requireNonNull(option);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanOption.class, DoubleOption.class, FloatOption.class, IntegerOption.class, StringOption.class, StringListOption.class}, option2, n)) {
                case 0: {
                    BooleanOption booleanOption = (BooleanOption)option2;
                    try {
                        booleanOption.setValue(readValue.getAsBoolean());
                    }
                    catch (Exception ignored) {
                        LOGGER.warn("Option '{}' of type '{}' in Config File '{}' is not of type Boolean, using Default Value", new Object[]{option.NAME, option.getClass(), configFile.getPath()});
                    }
                    continue block22;
                }
                case 1: {
                    DoubleOption doubleOption = (DoubleOption)option2;
                    try {
                        doubleOption.setValue(readValue.getAsDouble());
                    }
                    catch (Exception ignored) {
                        LOGGER.warn("Option '{}' of type '{}' in Config File '{}' is not of type Double, using Default Value", new Object[]{option.NAME, option.getClass(), configFile.getPath()});
                    }
                    continue block22;
                }
                case 2: {
                    FloatOption floatOption = (FloatOption)option2;
                    try {
                        floatOption.setValue(Float.valueOf(readValue.getAsFloat()));
                    }
                    catch (Exception ignored) {
                        LOGGER.warn("Option '{}' of type '{}' in Config File '{}' is not of type Float, using Default Value", new Object[]{option.NAME, option.getClass(), configFile.getPath()});
                    }
                    continue block22;
                }
                case 3: {
                    IntegerOption integerOption = (IntegerOption)option2;
                    try {
                        integerOption.setValue(readValue.getAsInt());
                    }
                    catch (Exception ignored) {
                        LOGGER.warn("Option '{}' of type '{}' in Config File '{}' is not of type Integer, using Default Value", new Object[]{option.NAME, option.getClass(), configFile.getPath()});
                    }
                    continue block22;
                }
                case 4: {
                    StringOption stringOption = (StringOption)option2;
                    try {
                        stringOption.setValue(readValue.getAsString());
                    }
                    catch (Exception ignored) {
                        LOGGER.warn("Option '{}' of type '{}' in Config File '{}' is not of type String, using Default Value", new Object[]{option.NAME, option.getClass(), configFile.getPath()});
                    }
                    continue block22;
                }
                case 5: {
                    StringListOption stringListOption = (StringListOption)option2;
                    try {
                        JsonArray jsonArray = readValue.getAsJsonArray();
                        LinkedList<String> strings = new LinkedList<String>();
                        for (JsonElement object : jsonArray) {
                            String str = object.getAsString();
                            if (!stringListOption.isEntryValid(str)) continue;
                            strings.add(str);
                        }
                        stringListOption.setValue(strings);
                    }
                    catch (Exception ignored) {
                        LOGGER.warn("Option '{}' of type '{}' in Config File '{}' is not of type StringArray, using Default Value", new Object[]{option.NAME, option.getClass(), configFile.getPath()});
                    }
                    continue block22;
                }
            }
            LOGGER.error("Tried to read Option with unknown Option Type: {}", option.getClass());
            LOGGER.error("To whichever Developer did this, don't forget to add write & read methods for your option types to all filetypes when you add option types when you add them!");
        }
        return expectedOptions;
    }

    @Override
    public void writeFile(File configFile, Logger LOGGER, List<Option<?>> options) throws IOException {
        FileWriter writer = new FileWriter(configFile);
        writer.write("{\n");
        for (int i = 0; i < options.size(); ++i) {
            Option<?> option = options.get(i);
            this.writeOption(writer, LOGGER, option, i == options.size() - 1);
        }
        writer.write("\n}");
        writer.flush();
        writer.close();
    }

    private void writeOption(FileWriter writer, Logger LOGGER, Option<?> option, boolean lastOption) throws IOException {
        String suffix = ",\n";
        if (lastOption) {
            suffix = "";
        }
        Option<?> option2 = option;
        Objects.requireNonNull(option2);
        Option<?> option3 = option2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanOption.class, DoubleOption.class, FloatOption.class, IntegerOption.class, StringOption.class, StringListOption.class}, option3, n)) {
            case 0: {
                BooleanOption booleanOption = (BooleanOption)option3;
                if (booleanOption.COMMENT != null) {
                    writer.write(String.format("\t\"__%s_comment\": \"%s\",\n", option.NAME, booleanOption.COMMENT));
                }
                writer.write(String.format("\t\"%s\": %b%s", option.NAME, booleanOption.getValue(), suffix));
                break;
            }
            case 1: {
                DoubleOption doubleOption = (DoubleOption)option3;
                if (doubleOption.COMMENT != null) {
                    writer.write(String.format("\t\"__%s_comment\": \"%s\",\n", option.NAME, doubleOption.COMMENT));
                }
                writer.write(String.format("\t\"%s\": %f%s", option.NAME, doubleOption.getValue(), suffix));
                break;
            }
            case 2: {
                FloatOption floatOption = (FloatOption)option3;
                if (floatOption.COMMENT != null) {
                    writer.write(String.format("\t\"__%s_comment\": \"%s\",\n", option.NAME, floatOption.COMMENT));
                }
                writer.write(String.format("\t\"%s\": %f%s", option.NAME, floatOption.getValue(), suffix));
                break;
            }
            case 3: {
                IntegerOption integerOption = (IntegerOption)option3;
                if (integerOption.COMMENT != null) {
                    writer.write(String.format("\t\"__%s_comment\": \"%s\",\n", option.NAME, integerOption.COMMENT));
                }
                writer.write(String.format("\t\"%s\": %d%s", option.NAME, integerOption.getValue(), suffix));
                break;
            }
            case 4: {
                StringOption stringOption = (StringOption)option3;
                if (stringOption.COMMENT != null) {
                    writer.write(String.format("\t\"__%s_comment\": \"%s\",\n", option.NAME, stringOption.COMMENT));
                }
                writer.write(String.format("\t\"%s\": \"%s\"%s", option.NAME, stringOption.getValue(), suffix));
                break;
            }
            case 5: {
                StringListOption stringListOption = (StringListOption)option3;
                if (stringListOption.COMMENT != null) {
                    writer.write(String.format("\t\"__%s_comment\": \"%s\",\n", option.NAME, stringListOption.COMMENT));
                }
                writer.write(String.format("\t\"%s\": [\n", option.NAME));
                String[] strings = ((List)stringListOption.getValue()).toArray(new String[0]);
                for (int i = 0; i < strings.length; ++i) {
                    if (i == strings.length - 1) {
                        writer.write(String.format("\t\t\"%s\"\n", strings[i]));
                        break;
                    }
                    writer.write(String.format("\t\t\"%s\",\n", strings[i]));
                }
                writer.write(String.format("\t]%s", suffix));
                break;
            }
            default: {
                LOGGER.error("Tried to write Option with unknown Option Type: {}", option.getClass());
                LOGGER.error("To whichever Developer did this, don't forget to add write & read methods for your option types to all filetypes when you add option types when you add them!");
            }
        }
    }
}

