/*
 * Decompiled with CFR 0.152.
 */
package net.fawnoculus.nochat.util.config.filetype;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import net.fawnoculus.nochat.util.ExceptionUtil;
import net.fawnoculus.nochat.util.config.ConfigFileType;
import net.fawnoculus.nochat.util.config.options.BooleanOption;
import net.fawnoculus.nochat.util.config.options.DoubleOption;
import net.fawnoculus.nochat.util.config.options.FloatOption;
import net.fawnoculus.nochat.util.config.options.IntegerOption;
import net.fawnoculus.nochat.util.config.options.Option;
import net.fawnoculus.nochat.util.config.options.StringListOption;
import net.fawnoculus.nochat.util.config.options.StringOption;
import org.slf4j.Logger;

public class PropertiesConfigFile
implements ConfigFileType {
    @Override
    public String getFileExtension() {
        return ".properties";
    }

    @Override
    public Boolean isValidOption(Option<?> option) {
        return !this.isStringInvalid(option.NAME);
    }

    @Override
    public Boolean isValidValue(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String[].class}, (Object)object2, n)) {
            case 0: {
                String string = (String)object2;
                return !this.isStringInvalid(string);
            }
            case 1: {
                String[] strings;
                for (String string : strings = (String[])object2) {
                    if (!this.isStringInvalid(string)) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private boolean isStringInvalid(String string) {
        return string.contains("\n") || string.contains("=") || string.contains("#");
    }

    @Override
    public List<Option<?>> readFile(File configFile, Logger LOGGER, List<Option<?>> expectedOptions) {
        Properties properties = new Properties();
        try {
            properties.load(new FileReader(configFile));
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse Properties Config File '{}' \nException: {}", (Object)configFile.getPath(), (Object)ExceptionUtil.makePretty(e));
            return expectedOptions;
        }
        block16: for (Option<?> expectedOption : expectedOptions) {
            Option<?> option;
            String readValue = properties.getProperty(expectedOption.NAME);
            if (readValue == null) {
                LOGGER.warn("Didn't find option '{}' of type '{}' in Config File '{}', using default value", new Object[]{expectedOption.NAME, expectedOption.getClass().getName(), configFile.getPath()});
                continue;
            }
            Objects.requireNonNull(expectedOption);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanOption.class, DoubleOption.class, FloatOption.class, IntegerOption.class, StringOption.class, StringListOption.class}, option, n)) {
                case 0: {
                    BooleanOption booleanOption = (BooleanOption)option;
                    booleanOption.setValue(Boolean.parseBoolean(readValue));
                    continue block16;
                }
                case 1: {
                    DoubleOption doubleOption = (DoubleOption)option;
                    try {
                        doubleOption.setValue(Double.parseDouble(readValue));
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to parse Double Option '{}' in Config File '{}' Exception: {}", new Object[]{doubleOption.NAME, configFile.getPath(), exception});
                    }
                    continue block16;
                }
                case 2: {
                    FloatOption floatOption = (FloatOption)option;
                    try {
                        floatOption.setValue(Float.valueOf(Float.parseFloat(readValue)));
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to parse Float Option '{}' in Config File '{}' Exception: {}", new Object[]{floatOption.NAME, configFile.getPath(), exception});
                    }
                    continue block16;
                }
                case 3: {
                    IntegerOption integerOption = (IntegerOption)option;
                    try {
                        integerOption.setValue(Integer.parseInt(readValue));
                    }
                    catch (Exception exception) {
                        LOGGER.error("Failed to parse Integer Option '{}' in Config File '{}' Exception: {}", new Object[]{integerOption.NAME, configFile.getPath(), exception});
                    }
                    continue block16;
                }
                case 4: {
                    StringOption stringOption = (StringOption)option;
                    stringOption.setValue(readValue);
                    continue block16;
                }
                case 5: {
                    StringListOption stringListOption = (StringListOption)option;
                    char[] Chars = readValue.toCharArray();
                    ArrayList<String> stringList = new ArrayList<String>();
                    StringBuilder currentString = new StringBuilder();
                    for (char currentChar : Chars) {
                        if (currentChar == ';' && currentString.isEmpty()) {
                            LOGGER.error("Failed to parse String List Option '{}' in Config File '{}': Unexpected ';' after empty String", (Object)stringListOption.NAME, (Object)configFile.getPath());
                            stringList = new ArrayList((Collection)stringListOption.getDefaultValue());
                            break;
                        }
                        if (currentChar != ';') {
                            currentString.append(currentChar);
                            continue;
                        }
                        if (stringListOption.isEntryValid(currentString.toString())) {
                            stringList.add(currentString.toString());
                        }
                        currentString = new StringBuilder();
                    }
                    if (!currentString.isEmpty()) {
                        stringList.add(currentString.toString());
                    }
                    stringListOption.setValue(stringList);
                    continue block16;
                }
            }
            LOGGER.error("Tried to read Option with unknown Option Type: {}", expectedOption.getClass());
            LOGGER.error("To whichever Developer did this, don't forget to add write & read methods for your option types to all filetypes when you add option types when you add them!");
        }
        return expectedOptions;
    }

    @Override
    public void writeFile(File configFile, Logger LOGGER, List<Option<?>> options) throws IOException {
        FileWriter writer = new FileWriter(configFile);
        block8: for (Option<?> option : options) {
            Option<?> option2;
            if (option.COMMENT != null) {
                writer.write(String.format("#%s\n", option.COMMENT));
            }
            Objects.requireNonNull(option);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringListOption.class, BooleanOption.class, DoubleOption.class, FloatOption.class, IntegerOption.class, StringOption.class}, option2, n)) {
                case 0: {
                    StringListOption stringListOption = (StringListOption)option2;
                    List stringList = (List)stringListOption.getValue();
                    writer.write(String.format("%s=%s", option.NAME, stringList.getFirst()));
                    for (int i = 1; i < stringList.size(); ++i) {
                        writer.write(String.format(";%s", stringList.get(i)));
                    }
                    writer.write("\n");
                    continue block8;
                }
                case 1: {
                    BooleanOption ignored = (BooleanOption)option2;
                    writer.write(String.format("%s=%s\n", option.NAME, option.getValue()));
                    continue block8;
                }
                case 2: {
                    DoubleOption ignored = (DoubleOption)option2;
                    writer.write(String.format("%s=%s\n", option.NAME, option.getValue()));
                    continue block8;
                }
                case 3: {
                    FloatOption ignored = (FloatOption)option2;
                    writer.write(String.format("%s=%s\n", option.NAME, option.getValue()));
                    continue block8;
                }
                case 4: {
                    IntegerOption ignored = (IntegerOption)option2;
                    writer.write(String.format("%s=%s\n", option.NAME, option.getValue()));
                    continue block8;
                }
                case 5: {
                    StringOption ignored = (StringOption)option2;
                    writer.write(String.format("%s=%s\n", option.NAME, option.getValue()));
                    continue block8;
                }
            }
            LOGGER.error("Tried to write Option with unknown Option Type: {}", option.getClass());
            LOGGER.error("To whichever Developer did this, don't forget to add write & read methods for your option types to all filetypes when you add option types when you add them!");
        }
        writer.flush();
        writer.close();
    }
}

