/*
 * Decompiled with CFR 0.152.
 */
package net.fawnoculus.nochat.util.config.options;

import java.util.List;
import net.fawnoculus.nochat.util.config.ConfigFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Option<T> {
    public final String NAME;
    public final String COMMENT;
    private final ConfigFile PARENT;
    private final T DEFAULT_VALUE;
    public ExtraType ExtraType = new ExtraType.Generic();
    private T default_overwrite;
    private T value;

    public Option(@NotNull ConfigFile parent, @NotNull String name, @NotNull T defaultValue, @Nullable String comment) {
        this.PARENT = parent;
        this.NAME = name;
        this.DEFAULT_VALUE = defaultValue;
        this.COMMENT = comment;
        if (this.isInvalidValue(defaultValue)) {
            throw new IllegalArgumentException("Default Value is not a valid for this Option");
        }
    }

    public T getValue() {
        return this.value != null ? this.value : this.getDefaultValue();
    }

    public T getDefaultValue() {
        return this.default_overwrite != null ? this.default_overwrite : this.DEFAULT_VALUE;
    }

    public void setValue(@NotNull T value) {
        if (this.isInvalidValue(value)) {
            return;
        }
        this.value = value;
    }

    public boolean isInvalidValue(@NotNull T value) {
        assert (this.PARENT != null);
        if (!this.additionalValidation(value)) {
            return true;
        }
        return this.PARENT.CONFIG_FILE_TYPE.isValidValue(value) == false;
    }

    abstract boolean additionalValidation(T var1);

    public void setExtraType(@NotNull ExtraType type) {
        this.ExtraType = type;
        if (this.isInvalidValue(this.getDefaultValue())) {
            throw new IllegalArgumentException("Default Value is not a valid for this ExtraType");
        }
    }

    public void resetToDefault() {
        this.setValue(this.getDefaultValue());
    }

    public void overwriteDefault(@NotNull T value) {
        this.default_overwrite = value;
        if (this.isInvalidValue(this.getDefaultValue())) {
            throw new IllegalArgumentException("New Default Value is not a valid for this Option");
        }
    }

    public void castAndOverwriteDefault(Object object) {
        if (object == null) {
            return;
        }
        this.overwriteDefault(this.value);
    }

    public static interface ExtraType {

        public record AllowedValues(String[] allowedValues) implements ExtraType
        {
            public boolean isValid(String string) {
                return List.of(this.allowedValues).contains(string);
            }
        }

        public record IntRange(int min, int max) implements ExtraType
        {
            public boolean isValid(int value) {
                return value > this.min && value < this.max;
            }

            public boolean isValid(double value) {
                return value > (double)this.min && value < (double)this.max;
            }
        }

        public record FloatRange(double min, double max) implements ExtraType
        {
            public boolean isValid(double value) {
                return value > this.min && value < this.max;
            }
        }

        public record Generic() implements ExtraType
        {
        }
    }
}

