/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.actuallydivision.item;

import net.mcreator.actuallydivision.procedures.PalisBlockDestroyedWithToolProcedure;
import net.mcreator.actuallydivision.procedures.PalisLivingEntityIsHitWithToolProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class PalisShovelItem
extends ShovelItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 300;
        }

        public float getSpeed() {
            return 6.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_IRON_TOOL;
        }

        public int getEnchantmentValue() {
            return 30;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public PalisShovelItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)3.75f, (float)-3.0f)));
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        boolean retval = super.mineBlock(itemstack, world, blockstate, pos, entity);
        PalisBlockDestroyedWithToolProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        return retval;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        PalisLivingEntityIsHitWithToolProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        return retval;
    }
}

