/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.curseofcurses.api;

import de.melanx.curseofcurses.ConfigHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CurseUtil {
    public static final Random RANDOM = new Random();
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean canEnchant(Optional<Holder<Enchantment>> enchantment, ItemStack stack) {
        return enchantment.isPresent() && enchantment.get().isBound() && enchantment.get().is(EnchantmentTags.CURSE) && !CurseUtil.hasEnchantment(enchantment.get(), stack) && stack.supportsEnchantment(enchantment.get());
    }

    private static boolean hasEnchantment(Holder<Enchantment> enchantment, ItemStack stack) {
        return stack.getTagEnchantments().keySet().contains(enchantment);
    }

    public static void applyCursesRandomly(Player player, double chance) {
        CurseUtil.applyCursesRandomly(player, chance, false, true);
    }

    public static void applyCursesRandomly(Player player, double chance, boolean ignoreEnchantments) {
        CurseUtil.applyCursesRandomly(player, chance, ignoreEnchantments, true);
    }

    public static void applyCursesRandomly(Player player, double chance, boolean ignoreEnchantments, boolean oneItemOnly) {
        Inventory inv = player.getInventory();
        ArrayList inventory = new ArrayList(inv.getNonEquipmentItems());
        Inventory.EQUIPMENT_SLOT_MAPPING.keySet().forEach(slot -> inventory.add(inv.getItem(slot)));
        Collections.shuffle(inventory);
        Registry enchantments = player.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        ArrayList<Holder> curses = new ArrayList<Holder>();
        for (Holder enchantmentHolder : enchantments.asHolderIdMap()) {
            if (!enchantmentHolder.is(EnchantmentTags.CURSE)) continue;
            curses.add(enchantmentHolder);
        }
        for (ItemStack stack : inventory) {
            if (stack.isEmpty() || !stack.isEnchantable() || stack.isEnchanted() && !ignoreEnchantments || !(chance > Math.random())) continue;
            Optional<Object> curse = Optional.empty();
            for (int j = 0; j < (Integer)ConfigHandler.curseAmount.get(); ++j) {
                ArrayList toCheck = new ArrayList(curses);
                Collections.shuffle(toCheck);
                while (!CurseUtil.canEnchant(curse, stack)) {
                    if (toCheck.isEmpty()) {
                        curse = Optional.empty();
                        break;
                    }
                    int index = RANDOM.nextInt(toCheck.size());
                    curse = Optional.of((Holder)toCheck.get(index));
                    toCheck.remove(index);
                }
                curse.ifPresent(enchantment -> {
                    stack.enchant(enchantment, ((Enchantment)enchantment.value()).getMaxLevel());
                    player.displayClientMessage((Component)Component.translatable((String)"curseofcurses.message", (Object[])new Object[]{stack.getHoverName(), Enchantment.getFullname((Holder)enchantment, (int)((Enchantment)enchantment.value()).getMaxLevel())}), false);
                    player.playNotifySound(SoundEvents.WITHER_AMBIENT, SoundSource.AMBIENT, 0.5f, 0.1f);
                });
            }
            if (!curse.isPresent() || !oneItemOnly) continue;
            break;
        }
    }
}

