/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bungeecord;

import it.renvins.serverpulse.api.ServerPulseProvider;
import it.renvins.serverpulse.api.metrics.IDiskRetriever;
import it.renvins.serverpulse.api.metrics.IPingRetriever;
import it.renvins.serverpulse.api.service.IDatabaseService;
import it.renvins.serverpulse.api.service.IMetricsService;
import it.renvins.serverpulse.api.service.Service;
import it.renvins.serverpulse.bungeecord.ServerPulseBungeeCord;
import it.renvins.serverpulse.bungeecord.ServerPulseBungeeCordAPI;
import it.renvins.serverpulse.bungeecord.commands.ServerPulseCommand;
import it.renvins.serverpulse.bungeecord.config.BungeeCordConfiguration;
import it.renvins.serverpulse.bungeecord.config.BungeeCordDatabaseConfiguration;
import it.renvins.serverpulse.bungeecord.config.BungeeCordMetricsConfiguration;
import it.renvins.serverpulse.bungeecord.logger.BungeeCordLogger;
import it.renvins.serverpulse.bungeecord.metrics.BungeeCordPingRetriever;
import it.renvins.serverpulse.bungeecord.platform.BungeeCordPlatform;
import it.renvins.serverpulse.bungeecord.scheduler.BungeeCordTaskScheduler;
import it.renvins.serverpulse.common.DatabaseService;
import it.renvins.serverpulse.common.MetricsService;
import it.renvins.serverpulse.common.metrics.DiskRetriever;
import it.renvins.serverpulse.common.platform.Platform;
import java.util.logging.Logger;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

public class ServerPulseBungeeCordLoader
implements Service {
    private final ServerPulseBungeeCord plugin;
    public static Logger LOGGER;
    private final BungeeCordConfiguration config;
    private final Platform platform;
    private final IDatabaseService databaseService;
    private final IMetricsService metricsService;
    private final IDiskRetriever diskRetriever;
    private final IPingRetriever pingRetriever;

    public ServerPulseBungeeCordLoader(ServerPulseBungeeCord plugin) {
        this.plugin = plugin;
        LOGGER = plugin.getLogger();
        this.config = new BungeeCordConfiguration(plugin, "config.yml");
        this.platform = new BungeeCordPlatform(plugin);
        BungeeCordLogger pulseLogger = new BungeeCordLogger(plugin);
        BungeeCordTaskScheduler scheduler = new BungeeCordTaskScheduler(plugin);
        BungeeCordDatabaseConfiguration dbConfig = new BungeeCordDatabaseConfiguration(this.config);
        BungeeCordMetricsConfiguration metricsConfig = new BungeeCordMetricsConfiguration(this.config);
        this.databaseService = new DatabaseService(pulseLogger, this.platform, dbConfig, scheduler);
        this.metricsService = new MetricsService(pulseLogger, this.platform, metricsConfig, scheduler);
        this.diskRetriever = new DiskRetriever(plugin.getDataFolder());
        this.pingRetriever = new BungeeCordPingRetriever(plugin);
        LOGGER.info("ServerPulse for BungeeCord initialized - waiting for server starting...");
    }

    @Override
    public void load() {
        LOGGER.info("Loading configuration...");
        this.config.load();
        this.plugin.getProxy().getPluginManager().registerCommand((Plugin)this.plugin, (Command)new ServerPulseCommand(this.config));
        ServerPulseProvider.register(new ServerPulseBungeeCordAPI(this.databaseService, this.metricsService, this.diskRetriever, this.pingRetriever));
        this.databaseService.load();
        if (!this.platform.isEnabled()) {
            return;
        }
        this.metricsService.load();
    }

    @Override
    public void unload() {
        this.databaseService.unload();
        this.metricsService.unload();
        this.plugin.getProxy().getScheduler().cancel((Plugin)this.plugin);
        ServerPulseProvider.unregister();
    }
}

