/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bungeecord.commands;

import it.renvins.serverpulse.bungeecord.commands.GeneralCommand;
import it.renvins.serverpulse.bungeecord.commands.ReloadCommand;
import it.renvins.serverpulse.bungeecord.commands.StatusCommand;
import it.renvins.serverpulse.bungeecord.config.BungeeCordConfiguration;
import it.renvins.serverpulse.common.utils.ChatUtils;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;

public class ServerPulseCommand
extends Command {
    private final BungeeCordConfiguration config;
    private final Map<String, GeneralCommand> commands = new HashMap<String, GeneralCommand>();

    public ServerPulseCommand(BungeeCordConfiguration config) {
        super("serverpulsebungeecord", "serverpulse.use", new String[]{"sp", "spb"});
        this.config = config;
        this.registerCommands();
    }

    public void execute(CommandSender sender, String[] args) {
        if (args.length == 0) {
            sender.sendMessage((BaseComponent)new TextComponent(ChatUtils.format(this.config.getConfig().getString("messages.noArgs"))));
            return;
        }
        String cmdName = args[0].toLowerCase();
        if (!this.commands.containsKey(cmdName)) {
            sender.sendMessage((BaseComponent)new TextComponent(ChatUtils.format(this.config.getConfig().getString("messages.noCommand"))));
            return;
        }
        GeneralCommand cmd = this.commands.get(cmdName);
        if (!sender.hasPermission(cmd.getPermission())) {
            sender.sendMessage((BaseComponent)new TextComponent(ChatUtils.format(this.config.getConfig().getString("messages.noPerms"))));
            return;
        }
        if (cmd.isPlayerOnly() && !(sender instanceof ProxiedPlayer)) {
            sender.sendMessage((BaseComponent)new TextComponent(ChatUtils.format(this.config.getConfig().getString("messages.playerOnly"))));
            return;
        }
        if (args.length > 1) {
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            cmd.run(sender, newArgs);
        } else {
            cmd.run(sender, new String[0]);
        }
    }

    private void registerCommands() {
        this.commands.put("reload", new ReloadCommand("serverpulse.reload", false, this.config));
        this.commands.put("status", new StatusCommand("serverpulse.status", false, this.config));
    }
}

