/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bungeecord.config;

import it.renvins.serverpulse.bungeecord.ServerPulseBungeeCord;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Level;
import lombok.Generated;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class BungeeCordConfiguration {
    private final ServerPulseBungeeCord plugin;
    private final String name;
    private File file;
    private Configuration config;

    public BungeeCordConfiguration(ServerPulseBungeeCord plugin, String name) {
        this.plugin = plugin;
        this.name = name;
    }

    public void load() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.file = new File(this.plugin.getDataFolder(), this.name);
        if (!this.file.exists()) {
            try (InputStream is = this.plugin.getResourceAsStream(this.name);){
                is.transferTo(Files.newOutputStream(this.file.toPath(), new OpenOption[0]));
                this.plugin.getLogger().info("Created default configuration file: " + this.name);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to copy default config", e);
            }
        }
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load config: " + this.name, e);
        }
    }

    public void save() {
        if (this.file == null || this.config == null) {
            return;
        }
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.config, this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save config!", e);
        }
    }

    public boolean reload() {
        try {
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(this.file);
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to reload config: " + this.name, e);
            return false;
        }
    }

    @Generated
    public Configuration getConfig() {
        return this.config;
    }
}

