/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bukkit;

import it.renvins.serverpulse.api.ServerPulseProvider;
import it.renvins.serverpulse.api.metrics.IDiskRetriever;
import it.renvins.serverpulse.api.metrics.IMSPTRetriever;
import it.renvins.serverpulse.api.metrics.IPingRetriever;
import it.renvins.serverpulse.api.metrics.ITPSRetriever;
import it.renvins.serverpulse.api.service.IDatabaseService;
import it.renvins.serverpulse.api.service.IMetricsService;
import it.renvins.serverpulse.api.service.Service;
import it.renvins.serverpulse.bukkit.ServerPulseBukkit;
import it.renvins.serverpulse.bukkit.ServerPulseBukkitAPI;
import it.renvins.serverpulse.bukkit.commands.ServerPulseCommand;
import it.renvins.serverpulse.bukkit.logger.BukkitLogger;
import it.renvins.serverpulse.bukkit.metrics.BukkitPingRetriever;
import it.renvins.serverpulse.bukkit.metrics.BukkitTPSRetriever;
import it.renvins.serverpulse.bukkit.metrics.PaperMSPTRetriever;
import it.renvins.serverpulse.bukkit.metrics.PaperTPSRetriever;
import it.renvins.serverpulse.bukkit.platform.BukkitPlatform;
import it.renvins.serverpulse.bukkit.scheduler.BukkitTaskScheduler;
import it.renvins.serverpulse.common.DatabaseService;
import it.renvins.serverpulse.common.MetricsService;
import it.renvins.serverpulse.common.config.GeneralConfiguration;
import it.renvins.serverpulse.common.disk.DiskRetriever;
import it.renvins.serverpulse.common.metrics.LineProtocolFormatter;
import it.renvins.serverpulse.common.metrics.MetricsCollector;
import it.renvins.serverpulse.common.metrics.UnsupportedMSPTRetriever;
import it.renvins.serverpulse.common.platform.Platform;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ServerPulseBukkitLoader
implements Service {
    private final ServerPulseBukkit plugin;
    public static Logger LOGGER;
    private final GeneralConfiguration config;
    private final Platform platform;
    private final IDatabaseService databaseService;
    private final ITPSRetriever tpsRetriever;
    private final IDiskRetriever diskRetriever;
    private final IPingRetriever pingRetriever;
    private final IMSPTRetriever msptRetriever;
    private final IMetricsService metricsService;

    public ServerPulseBukkitLoader(ServerPulseBukkit plugin) {
        this.plugin = plugin;
        LOGGER = plugin.getLogger();
        BukkitLogger logger = new BukkitLogger(LOGGER);
        this.config = new GeneralConfiguration(logger, plugin.getDataFolder(), "config.yml");
        this.platform = new BukkitPlatform(plugin);
        BukkitTaskScheduler taskScheduler = new BukkitTaskScheduler(plugin);
        this.databaseService = new DatabaseService(logger, this.platform, this.config, taskScheduler);
        if (this.isPaper()) {
            this.tpsRetriever = new PaperTPSRetriever();
            this.msptRetriever = new PaperMSPTRetriever();
        } else {
            this.tpsRetriever = new BukkitTPSRetriever(plugin);
            this.msptRetriever = new UnsupportedMSPTRetriever();
        }
        this.diskRetriever = new DiskRetriever(plugin.getDataFolder());
        this.pingRetriever = new BukkitPingRetriever();
        MetricsCollector collector = new MetricsCollector(logger, this.platform, this.tpsRetriever, this.diskRetriever, this.pingRetriever, this.msptRetriever);
        LineProtocolFormatter formatter = new LineProtocolFormatter(this.config);
        this.metricsService = new MetricsService(logger, collector, formatter, taskScheduler, this.databaseService);
        LOGGER.info("ServerPulse for Bukkit/Paper initialized - waiting for server starting...");
    }

    @Override
    public void load() {
        LOGGER.info("Loading configuration...");
        this.config.load();
        this.databaseService.load();
        if (!this.platform.isEnabled()) {
            return;
        }
        if (this.tpsRetriever instanceof BukkitTPSRetriever) {
            LOGGER.info("Starting tick monitoring task...");
            ((BukkitTPSRetriever)this.tpsRetriever).startTickMonitor();
        }
        if (this.msptRetriever instanceof PaperMSPTRetriever) {
            LOGGER.info("Registering PaperMSPTRetriever event listener...");
            this.plugin.getServer().getPluginManager().registerEvents((Listener)((PaperMSPTRetriever)this.msptRetriever), (Plugin)this.plugin);
        }
        this.metricsService.load();
        long intervalTicks = this.config.getConfig().getLong("metrics.interval", 5L) * 20L;
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this.metricsService::collectAndSendMetrics, 0L, intervalTicks);
        this.plugin.getCommand("serverpulse").setExecutor((CommandExecutor)new ServerPulseCommand(this.config));
        ServerPulseProvider.register(new ServerPulseBukkitAPI(this.databaseService, this.metricsService, this.tpsRetriever, this.diskRetriever, this.pingRetriever));
    }

    @Override
    public void unload() {
        this.databaseService.unload();
        this.metricsService.unload();
        this.plugin.getServer().getScheduler().cancelTasks((Plugin)this.plugin);
        ServerPulseProvider.unregister();
    }

    private boolean isPaper() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            LOGGER.info("Server is running Paper (or a Paper fork). Using PaperTPSRetriever.");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Server is not running Paper (or a Paper fork). Using BukkitTPSRetriever.");
            return false;
        }
    }
}

