/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bukkit.commands;

import it.renvins.serverpulse.bukkit.commands.GeneralCommand;
import it.renvins.serverpulse.bukkit.commands.ReloadCommand;
import it.renvins.serverpulse.bukkit.commands.StatusCommand;
import it.renvins.serverpulse.common.config.GeneralConfiguration;
import it.renvins.serverpulse.common.utils.ChatUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ServerPulseCommand
implements CommandExecutor {
    private final GeneralConfiguration config;
    private final Map<String, GeneralCommand> commands = new HashMap<String, GeneralCommand>();

    public ServerPulseCommand(GeneralConfiguration config) {
        this.config = config;
        this.registerCommands();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 0) {
            sender.sendMessage(ChatUtils.format(this.config.getConfig().getString("messages.noArgs")));
            return true;
        }
        String cmdName = args[0].toLowerCase();
        if (!this.commands.containsKey(cmdName)) {
            sender.sendMessage(ChatUtils.format(this.config.getConfig().getString("messages.noCommand")));
            return true;
        }
        GeneralCommand cmd = this.commands.get(cmdName);
        if (!sender.hasPermission(cmd.getPermission())) {
            sender.sendMessage(ChatUtils.format(this.config.getConfig().getString("messages.noPerms")));
            return true;
        }
        if (cmd.isPlayerOnly() && !(sender instanceof Player)) {
            sender.sendMessage(ChatUtils.format(this.config.getConfig().getString("messages.playerOnly")));
            return true;
        }
        if (args.length > 1) {
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            cmd.run(sender, newArgs);
        } else {
            cmd.run(sender, new String[0]);
        }
        return true;
    }

    private void registerCommands() {
        this.commands.put("reload", new ReloadCommand("serverpulse.reload", false, this.config));
        this.commands.put("status", new StatusCommand("serverpulse.status", false, this.config));
    }
}

