/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bukkit.metrics;

import it.renvins.serverpulse.api.metrics.ITPSRetriever;
import it.renvins.serverpulse.bukkit.ServerPulseBukkit;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BukkitTPSRetriever
implements ITPSRetriever {
    private static final int MAX_HISTORY_SIZE = 18000;
    private final Queue<Long> tickTimestamps = new ConcurrentLinkedDeque<Long>();
    private final ServerPulseBukkit plugin;

    public BukkitTPSRetriever(ServerPulseBukkit plugin) {
        this.plugin = plugin;
    }

    @Override
    public double[] getTPS() {
        long currentTime = System.currentTimeMillis();
        long oneMinuteAgo = currentTime - 60000L;
        long fiveMinutesAgo = currentTime - 300000L;
        long fifteenMinutesAgo = currentTime - 900000L;
        int ticks1m = 0;
        int ticks5m = 0;
        int ticks15m = 0;
        Iterator iterator = this.tickTimestamps.iterator();
        while (iterator.hasNext()) {
            long timeStamp = (Long)iterator.next();
            if (timeStamp >= oneMinuteAgo) {
                ++ticks1m;
            }
            if (timeStamp >= fiveMinutesAgo) {
                ++ticks5m;
            }
            if (timeStamp < fifteenMinutesAgo) continue;
            ++ticks15m;
        }
        double tps1m = (double)ticks1m / 60.0;
        double tps5m = (double)ticks5m / 300.0;
        double tps15m = (double)ticks15m / 900.0;
        return new double[]{Math.min(20.0, tps1m), Math.min(20.0, tps5m), Math.min(20.0, tps15m)};
    }

    public void startTickMonitor() {
        new BukkitRunnable(){

            public void run() {
                BukkitTPSRetriever.this.tickTimestamps.offer(System.currentTimeMillis());
                if (BukkitTPSRetriever.this.tickTimestamps.size() > 18000) {
                    BukkitTPSRetriever.this.tickTimestamps.poll();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }
}

