/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bukkit.platform;

import it.renvins.serverpulse.api.data.WorldData;
import it.renvins.serverpulse.bukkit.ServerPulseBukkit;
import it.renvins.serverpulse.common.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.World;

public class BukkitPlatform
implements Platform {
    private final ServerPulseBukkit plugin;

    public BukkitPlatform(ServerPulseBukkit plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    @Override
    public void disable() {
        this.plugin.getServer().shutdown();
    }

    @Override
    public boolean isPrimaryThread() {
        return this.plugin.getServer().isPrimaryThread();
    }

    @Override
    public int getOnlinePlayerCount() {
        return this.plugin.getServer().getOnlinePlayers().size();
    }

    @Override
    public Map<String, WorldData> getWorldsData() {
        HashMap<String, WorldData> worldsData = new HashMap<String, WorldData>();
        for (World world : this.plugin.getServer().getWorlds()) {
            String name = world.getName();
            WorldData data = new WorldData(world.getEntities().size(), world.getLoadedChunks().length);
            worldsData.put(name, data);
        }
        return worldsData;
    }
}

