/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.common.metrics;

import it.renvins.serverpulse.api.metrics.IMSPTRetriever;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;

public class CommonMSPTRetriever
implements IMSPTRetriever {
    private final Queue<Double> ticks = new ConcurrentLinkedDeque<Double>();
    private static final int MAX_HISTORY_SIZE = 18000;

    public void addTickDuration(double tickDuration) {
        this.ticks.offer(tickDuration);
        if (this.ticks.size() > 18000) {
            this.ticks.poll();
        }
    }

    @Override
    public double getLastMSPT() {
        if (this.ticks.isEmpty()) {
            return 0.0;
        }
        Double[] durations = this.ticks.toArray(new Double[0]);
        return durations[durations.length - 1];
    }

    @Override
    public double getAverageMSPT(int ticksCount) {
        if (this.ticks.isEmpty() || ticksCount <= 0) {
            return 0.0;
        }
        List<Double> relevantTicks = this.getRelevantTicks(ticksCount);
        if (relevantTicks.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        for (double duration : relevantTicks) {
            sum += duration;
        }
        return sum / (double)relevantTicks.size();
    }

    @Override
    public double getMinMSPT(int ticksCount) {
        if (this.ticks.isEmpty()) {
            return 0.0;
        }
        List<Double> relevantTicks = this.getRelevantTicks(ticksCount);
        if (relevantTicks.isEmpty()) {
            return 0.0;
        }
        return relevantTicks.stream().min(Double::compareTo).orElse(0.0);
    }

    @Override
    public double getMaxMSPT(int ticksCount) {
        if (this.ticks.isEmpty()) {
            return 0.0;
        }
        List<Double> relevantTicks = this.getRelevantTicks(ticksCount);
        if (relevantTicks.isEmpty()) {
            return 0.0;
        }
        return relevantTicks.stream().max(Double::compareTo).orElse(0.0);
    }

    private List<Double> getRelevantTicks(int ticksCount) {
        ArrayList<Double> recentTicks = new ArrayList<Double>(this.ticks);
        int startIndex = Math.max(0, recentTicks.size() - ticksCount);
        return recentTicks.subList(startIndex, recentTicks.size());
    }
}

