/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import it.renvins.serverpulse.api.ServerPulseProvider;
import it.renvins.serverpulse.api.metrics.IDiskRetriever;
import it.renvins.serverpulse.api.metrics.IPingRetriever;
import it.renvins.serverpulse.api.service.IDatabaseService;
import it.renvins.serverpulse.api.service.IMetricsService;
import it.renvins.serverpulse.common.DatabaseService;
import it.renvins.serverpulse.common.MetricsService;
import it.renvins.serverpulse.common.config.GeneralConfiguration;
import it.renvins.serverpulse.common.disk.DiskRetriever;
import it.renvins.serverpulse.common.logger.PulseLogger;
import it.renvins.serverpulse.common.metrics.LineProtocolFormatter;
import it.renvins.serverpulse.common.metrics.MetricsCollector;
import it.renvins.serverpulse.common.metrics.UnsupportedMSPTRetriever;
import it.renvins.serverpulse.common.metrics.UnsupportedTPSRetriever;
import it.renvins.serverpulse.velocity.ServerPulseVelocityAPI;
import it.renvins.serverpulse.velocity.commands.ServerPulseCommand;
import it.renvins.serverpulse.velocity.logger.VelocityLogger;
import it.renvins.serverpulse.velocity.metrics.VelocityPingRetriever;
import it.renvins.serverpulse.velocity.platform.VelocityPlatform;
import it.renvins.serverpulse.velocity.scheduler.VelocityTaskScheduler;
import java.nio.file.Path;
import lombok.Generated;
import org.slf4j.Logger;

@Plugin(id="serverpulse", name="ServerPulse", version="0.5.0-SNAPSHOT", description="Effortless Minecraft performance monitoring with pre-configured Grafana/InfluxDB via Docker.", authors={"renvins"})
public class ServerPulseVelocity {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private PulseLogger pulseLogger;
    private GeneralConfiguration config;
    private IDatabaseService databaseService;
    private IDiskRetriever diskRetriever;
    private IPingRetriever pingRetriever;
    private IMetricsService metricsService;

    @Inject
    public ServerPulseVelocity(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        logger.info("ServerPulse for Velocity initialized - waiting for proxy starting...");
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.pulseLogger = new VelocityLogger(this.logger);
        this.config = new GeneralConfiguration(this.pulseLogger, this.dataDirectory.toFile(), "config.yml");
        this.logger.info("Loading configuration file...");
        this.config.load();
        VelocityPlatform platform = new VelocityPlatform(this);
        VelocityTaskScheduler scheduler = new VelocityTaskScheduler(this);
        this.databaseService = new DatabaseService(this.pulseLogger, platform, this.config, scheduler);
        this.diskRetriever = new DiskRetriever(this.dataDirectory.toFile());
        this.pingRetriever = new VelocityPingRetriever(this);
        UnsupportedTPSRetriever tpsRetriever = new UnsupportedTPSRetriever();
        UnsupportedMSPTRetriever msptRetriever = new UnsupportedMSPTRetriever();
        MetricsCollector collector = new MetricsCollector(this.pulseLogger, platform, tpsRetriever, this.diskRetriever, this.pingRetriever, msptRetriever);
        LineProtocolFormatter formatter = new LineProtocolFormatter(this.config);
        this.metricsService = new MetricsService(this.pulseLogger, collector, formatter, scheduler, this.databaseService);
        this.databaseService.load();
        if (this.server.isShuttingDown()) {
            return;
        }
        this.metricsService.load();
        long intervalTicks = this.config.getConfig().getLong("metrics.interval", 5L) * 20L;
        scheduler.runTaskTimerAsync(this.metricsService::collectAndSendMetrics, 0L, intervalTicks);
        CommandMeta meta = this.server.getCommandManager().metaBuilder("serverpulsevelocity").plugin((Object)this).aliases(new String[]{"spv"}).build();
        this.server.getCommandManager().register(meta, (Command)new ServerPulseCommand(this.config).createCommand());
        ServerPulseProvider.register(new ServerPulseVelocityAPI(this.databaseService, this.metricsService, this.diskRetriever, this.pingRetriever));
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.databaseService != null) {
            this.databaseService.unload();
        }
        if (this.metricsService != null) {
            this.metricsService.unload();
        }
        try {
            ServerPulseProvider.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.logger.info("ServerPulse for Velocity has been shut down.");
    }

    @Generated
    public ProxyServer getServer() {
        return this.server;
    }
}

