/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.api.data;

import java.util.HashMap;
import java.util.Map;

public class LineProtocolPoint {
    private final String measurement;
    private final Map<String, String> tags;
    private final Map<String, Object> fields;
    private long timestamp;

    public LineProtocolPoint(String measurement) {
        this.measurement = measurement;
        this.tags = new HashMap<String, String>();
        this.fields = new HashMap<String, Object>();
    }

    public LineProtocolPoint addTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public LineProtocolPoint addField(String key, Object value) {
        this.fields.put(key, value);
        return this;
    }

    public LineProtocolPoint setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String toLineProtocol() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.measurement);
        if (!this.tags.isEmpty()) {
            sb.append(",");
            this.tags.forEach((key, value) -> sb.append((String)key).append("=").append((String)value).append(","));
            sb.setLength(sb.length() - 1);
        }
        sb.append(" ");
        if (!this.fields.isEmpty()) {
            this.fields.forEach((key, value) -> {
                sb.append((String)key).append("=");
                if (value instanceof String) {
                    sb.append("\"").append(value).append("\"");
                } else if (value instanceof Integer || value instanceof Long) {
                    sb.append(value).append("i");
                } else {
                    sb.append(value);
                }
                sb.append(",");
            });
            sb.setLength(sb.length() - 1);
        }
        sb.append(" ").append(this.timestamp);
        return sb.toString();
    }
}

