/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bungeecord;

import it.renvins.serverpulse.api.ServerPulseProvider;
import it.renvins.serverpulse.api.metrics.IDiskRetriever;
import it.renvins.serverpulse.api.metrics.IPingRetriever;
import it.renvins.serverpulse.api.service.IDatabaseService;
import it.renvins.serverpulse.api.service.IMetricsService;
import it.renvins.serverpulse.api.service.Service;
import it.renvins.serverpulse.bungeecord.ServerPulseBungeeCord;
import it.renvins.serverpulse.bungeecord.ServerPulseBungeeCordAPI;
import it.renvins.serverpulse.bungeecord.commands.ServerPulseCommand;
import it.renvins.serverpulse.bungeecord.logger.BungeeCordLogger;
import it.renvins.serverpulse.bungeecord.metrics.BungeeCordPingRetriever;
import it.renvins.serverpulse.bungeecord.platform.BungeeCordPlatform;
import it.renvins.serverpulse.bungeecord.scheduler.BungeeCordTaskScheduler;
import it.renvins.serverpulse.common.DatabaseService;
import it.renvins.serverpulse.common.MetricsService;
import it.renvins.serverpulse.common.config.GeneralConfiguration;
import it.renvins.serverpulse.common.disk.DiskRetriever;
import it.renvins.serverpulse.common.metrics.LineProtocolFormatter;
import it.renvins.serverpulse.common.metrics.MetricsCollector;
import it.renvins.serverpulse.common.metrics.UnsupportedMSPTRetriever;
import it.renvins.serverpulse.common.metrics.UnsupportedTPSRetriever;
import it.renvins.serverpulse.common.platform.Platform;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

public class ServerPulseBungeeCordLoader
implements Service {
    private final ServerPulseBungeeCord plugin;
    public static Logger LOGGER;
    private final GeneralConfiguration config;
    private final Platform platform;
    private final IDatabaseService databaseService;
    private final IDiskRetriever diskRetriever;
    private final IPingRetriever pingRetriever;
    private final IMetricsService metricsService;

    public ServerPulseBungeeCordLoader(ServerPulseBungeeCord plugin) {
        this.plugin = plugin;
        LOGGER = plugin.getLogger();
        BungeeCordLogger pulseLogger = new BungeeCordLogger(plugin);
        this.config = new GeneralConfiguration(pulseLogger, plugin.getDataFolder(), "config.yml");
        this.platform = new BungeeCordPlatform(plugin);
        BungeeCordTaskScheduler scheduler = new BungeeCordTaskScheduler(plugin);
        this.databaseService = new DatabaseService(pulseLogger, this.platform, this.config, scheduler);
        this.diskRetriever = new DiskRetriever(plugin.getDataFolder());
        this.pingRetriever = new BungeeCordPingRetriever(plugin);
        UnsupportedTPSRetriever tpsRetriever = new UnsupportedTPSRetriever();
        UnsupportedMSPTRetriever msptRetriever = new UnsupportedMSPTRetriever();
        MetricsCollector collector = new MetricsCollector(pulseLogger, this.platform, tpsRetriever, this.diskRetriever, this.pingRetriever, msptRetriever);
        LineProtocolFormatter formatter = new LineProtocolFormatter(this.config);
        this.metricsService = new MetricsService(pulseLogger, collector, formatter, scheduler, this.databaseService);
        LOGGER.info("ServerPulse for BungeeCord initialized - waiting for server starting...");
    }

    @Override
    public void load() {
        LOGGER.info("Loading configuration...");
        this.config.load();
        this.databaseService.load();
        if (!this.platform.isEnabled()) {
            return;
        }
        this.metricsService.load();
        long intervalSeconds = this.config.getConfig().getLong("metrics.interval", 5L);
        this.plugin.getProxy().getScheduler().schedule((Plugin)this.plugin, this.metricsService::collectAndSendMetrics, 0L, intervalSeconds, TimeUnit.SECONDS);
        this.plugin.getProxy().getPluginManager().registerCommand((Plugin)this.plugin, (Command)new ServerPulseCommand(this.config));
        ServerPulseProvider.register(new ServerPulseBungeeCordAPI(this.databaseService, this.metricsService, this.diskRetriever, this.pingRetriever));
    }

    @Override
    public void unload() {
        this.databaseService.unload();
        this.metricsService.unload();
        this.plugin.getProxy().getScheduler().cancel((Plugin)this.plugin);
        ServerPulseProvider.unregister();
    }
}

