/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.common;

import it.renvins.serverpulse.api.data.AsyncMetricsSnapshot;
import it.renvins.serverpulse.api.data.SyncMetricsSnapshot;
import it.renvins.serverpulse.api.service.IDatabaseService;
import it.renvins.serverpulse.api.service.IMetricsService;
import it.renvins.serverpulse.common.logger.PulseLogger;
import it.renvins.serverpulse.common.metrics.LineProtocolFormatter;
import it.renvins.serverpulse.common.metrics.MetricsCollector;
import it.renvins.serverpulse.common.scheduler.TaskScheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class MetricsService
implements IMetricsService {
    private final PulseLogger logger;
    private final MetricsCollector collector;
    private final LineProtocolFormatter formatter;
    private final TaskScheduler scheduler;
    private final Executor asyncExecutor;
    private final IDatabaseService databaseService;

    public MetricsService(PulseLogger logger, MetricsCollector collector, LineProtocolFormatter formatter, TaskScheduler scheduler, IDatabaseService databaseService) {
        this.logger = logger;
        this.collector = collector;
        this.formatter = formatter;
        this.scheduler = scheduler;
        this.asyncExecutor = scheduler::runAsync;
        this.databaseService = databaseService;
    }

    @Override
    public void load() {
        this.logger.info("Loading metrics task...");
    }

    @Override
    public void collectAndSendMetrics() {
        if (!this.databaseService.isConnected()) {
            return;
        }
        CompletableFuture<SyncMetricsSnapshot> syncFuture = CompletableFuture.supplyAsync(this.collector::collectSyncSnapshot, this.scheduler.getSyncExecutor());
        CompletableFuture<AsyncMetricsSnapshot> asyncFuture = CompletableFuture.supplyAsync(this.collector::collectAsyncSnapshot, this.asyncExecutor);
        ((CompletableFuture)((CompletableFuture)syncFuture.thenCombineAsync(asyncFuture, (syncData, asyncData) -> this.formatter.format((SyncMetricsSnapshot)syncData, (AsyncMetricsSnapshot)asyncData), this.asyncExecutor)).thenAcceptAsync(this::sendPoints, this.asyncExecutor)).exceptionally(ex -> {
            this.logger.error("Failed during metrics collection or sending.", (Throwable)ex);
            return null;
        });
    }

    private void sendPoints(List<String> points) {
        if (points == null || points.isEmpty()) {
            return;
        }
        try {
            String body = String.join((CharSequence)"\n", points);
            this.databaseService.writeLineProtocol(body);
        }
        catch (Exception e) {
            this.logger.error("Failed to send metrics data to the database.", e);
        }
    }
}

