/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.common;

import it.renvins.serverpulse.api.service.IDatabaseService;
import it.renvins.serverpulse.common.config.DatabaseConfiguration;
import it.renvins.serverpulse.common.logger.PulseLogger;
import it.renvins.serverpulse.common.platform.Platform;
import it.renvins.serverpulse.common.scheduler.Task;
import it.renvins.serverpulse.common.scheduler.TaskScheduler;
import it.renvins.serverpulse.velocity.libs.influxdb.client.InfluxDBClient;
import it.renvins.serverpulse.velocity.libs.influxdb.client.InfluxDBClientFactory;
import it.renvins.serverpulse.velocity.libs.influxdb.client.WriteApi;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import lombok.Generated;

public class DatabaseService
implements IDatabaseService {
    private final PulseLogger logger;
    private final Platform platform;
    private final DatabaseConfiguration configuration;
    private final TaskScheduler scheduler;
    private HttpClient httpClient;
    private InfluxDBClient client;
    private WriteApi writeApi;
    private volatile Task retryTask;
    private final int MAX_RETRIES = 5;
    private final long RETRY_DELAY_TICKS = 600L;
    private volatile boolean isConnected = false;
    private volatile int retryCount = 0;

    public DatabaseService(PulseLogger logger, Platform platform, DatabaseConfiguration configuration, TaskScheduler scheduler) {
        this.logger = logger;
        this.platform = platform;
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    @Override
    public void load() {
        if (!this.checkConnectionData()) {
            this.logger.error("InfluxDB connection data is missing or invalid. Shutting down...");
            this.platform.disable();
            return;
        }
        this.logger.info("Connecting to InfluxDB...");
        this.scheduler.runAsync(this::connect);
    }

    @Override
    public void unload() {
        this.logger.info("Unloading InfluxDB connection...");
        this.stopRetryTask();
        this.disconnect();
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    @Override
    public boolean ping() {
        HttpRequest request;
        String url = this.configuration.getHost();
        if (url == null || url.isEmpty()) {
            this.logger.error("InfluxDB URL is missing for ping...");
            return false;
        }
        if (this.httpClient == null) {
            this.logger.error("HttpClient not initialized for ping...");
            this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        }
        try {
            String pingUrl = url.endsWith("/") ? url + "ping" : url + "/ping";
            request = HttpRequest.newBuilder().uri(URI.create(pingUrl)).GET().timeout(Duration.ofSeconds(5L)).build();
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Invalid InfluxDB URL format for ping: " + url, e);
            return false;
        }
        try {
            HttpResponse<Void> response = this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
            return response.statusCode() == 204;
        }
        catch (ConnectException | UnknownHostException e) {
            this.logger.warning("InfluxDB service is offline...");
            return false;
        }
        catch (SocketTimeoutException e) {
            this.logger.warning("InfluxDB ping timed out: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.logger.error("Error during InfluxDB ping: " + e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    private void connect() {
        this.disconnect();
        String url = this.configuration.getHost();
        String token = this.configuration.getToken();
        String org = this.configuration.getOrg();
        String bucket = this.configuration.getBucket();
        try {
            this.logger.info("Attempting to connect to InfluxDB at " + url);
            this.client = InfluxDBClientFactory.create(url, token.toCharArray(), org, bucket);
            boolean isPingSuccessful = this.ping();
            if (isPingSuccessful) {
                this.writeApi = this.client.makeWriteApi();
                this.isConnected = true;
                this.retryCount = 0;
                this.stopRetryTask();
                this.logger.info("Successfully connected to InfluxDB and ping successful...");
            } else {
                this.logger.warning("Created InfluxDB instance, but ping failed. Will retry...");
                this.isConnected = false;
                if (this.client != null) {
                    this.client.close();
                    this.client = null;
                }
                this.startRetryTaskIfNeeded();
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to connect or ping InfluxDB: " + e.getMessage());
            this.isConnected = false;
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            this.startRetryTaskIfNeeded();
        }
    }

    @Override
    public void disconnect() {
        if (this.writeApi != null) {
            try {
                this.writeApi.close();
            }
            catch (Exception e) {
                this.logger.error("Error closing InfluxDB WriteApi...", e);
            }
            this.writeApi = null;
        }
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                this.logger.error("Error closing InfluxDB Client...", e);
            }
            this.client = null;
        }
        this.isConnected = false;
    }

    @Override
    public synchronized void startRetryTaskIfNeeded() {
        if (this.retryTask != null && !this.retryTask.isCancelled()) {
            return;
        }
        if (!this.platform.isEnabled()) {
            this.logger.warning("Plugin disabling, not starting retry task...");
            return;
        }
        this.retryCount = 0;
        this.logger.warning("Connection failed. Starting connection retry task (Max 5 attempts)...");
        this.retryTask = this.scheduler.runTaskTimerAsync(() -> {
            if (this.isConnected) {
                this.logger.info("Connection successful, stopping retry task...");
                this.stopRetryTask();
                return;
            }
            if (!this.platform.isEnabled()) {
                this.logger.warning("Plugin disabled during retry task execution...");
                this.stopRetryTask();
                return;
            }
            if (this.retryCount >= 5) {
                this.logger.error("Max connection retries (5) reached. Disabling ServerPulse metrics...");
                this.stopRetryTask();
                this.disconnect();
                this.scheduler.runSync(this.platform::disable);
                return;
            }
            ++this.retryCount;
            this.logger.info("Retrying InfluxDB connection... Attempt " + this.retryCount + "/5");
            this.connect();
        }, 600L, 600L);
    }

    private synchronized void stopRetryTask() {
        if (this.retryTask != null) {
            if (!this.retryTask.isCancelled()) {
                try {
                    this.retryTask.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.retryTask = null;
        }
    }

    private boolean checkConnectionData() {
        String url = this.configuration.getHost();
        String token = this.configuration.getToken();
        String org = this.configuration.getOrg();
        String bucket = this.configuration.getBucket();
        boolean valid = true;
        if (url == null || url.isEmpty()) {
            this.logger.error("Missing or empty 'metrics.influxdb.url' in config...");
            valid = false;
        }
        if (bucket == null || bucket.isEmpty()) {
            this.logger.error("Missing or empty 'metrics.influxdb.bucket' in config...");
            valid = false;
        }
        if (org == null || org.isEmpty()) {
            this.logger.error("Missing or empty 'metrics.influxdb.org' in config...");
            valid = false;
        }
        if (token == null || token.isEmpty() || token.equals("my-token")) {
            this.logger.error("Missing, empty, or default 'metrics.influxdb.token' in config...");
            valid = false;
        }
        return valid;
    }

    @Override
    @Generated
    public InfluxDBClient getClient() {
        return this.client;
    }

    @Override
    @Generated
    public WriteApi getWriteApi() {
        return this.writeApi;
    }
}

