/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.common;

import it.renvins.serverpulse.api.ServerPulseProvider;
import it.renvins.serverpulse.api.data.SyncMetricsSnapshot;
import it.renvins.serverpulse.api.data.WorldData;
import it.renvins.serverpulse.api.service.IMetricsService;
import it.renvins.serverpulse.api.utils.MemoryUtils;
import it.renvins.serverpulse.common.config.MetricsConfiguration;
import it.renvins.serverpulse.common.logger.PulseLogger;
import it.renvins.serverpulse.common.platform.Platform;
import it.renvins.serverpulse.common.scheduler.TaskScheduler;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.WritePrecision;
import it.renvins.serverpulse.velocity.libs.influxdb.client.write.Point;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class MetricsService
implements IMetricsService {
    private final PulseLogger logger;
    private final Platform platform;
    private final MetricsConfiguration configuration;
    private final TaskScheduler scheduler;
    private final Executor asyncExecutor;

    public MetricsService(PulseLogger logger, Platform platform, MetricsConfiguration configuration, TaskScheduler scheduler) {
        this.logger = logger;
        this.platform = platform;
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.asyncExecutor = scheduler::runAsync;
    }

    @Override
    public void load() {
        this.logger.info("Loading metrics task...");
        this.loadTask();
    }

    @Override
    public void collectAndSendMetrics() {
        if (!ServerPulseProvider.get().getDatabaseService().isConnected() || ServerPulseProvider.get().getDatabaseService().getWriteApi() == null) {
            return;
        }
        if (!ServerPulseProvider.get().getDatabaseService().ping()) {
            ServerPulseProvider.get().getDatabaseService().disconnect();
            ServerPulseProvider.get().getDatabaseService().startRetryTaskIfNeeded();
            return;
        }
        ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(this::collectSnapshot, this.scheduler.getSyncExecutor()).thenApplyAsync(snapshot -> {
            if (snapshot == null) {
                this.logger.warning("Snapshot is null. Skipping metrics send.");
                throw new IllegalStateException("Sync metric collection failed.");
            }
            long usedHeap = MemoryUtils.getUsedHeapBytes();
            long committedHeap = MemoryUtils.getCommittedHeapBytes();
            long totalDisk = ServerPulseProvider.get().getDiskRetriever().getTotalSpace();
            long usableDisk = ServerPulseProvider.get().getDiskRetriever().getUsableSpace();
            int minPing = ServerPulseProvider.get().getPingRetriever().getMinPing();
            int maxPing = ServerPulseProvider.get().getPingRetriever().getMaxPing();
            int avgPing = ServerPulseProvider.get().getPingRetriever().getAveragePing();
            return this.buildPoints((SyncMetricsSnapshot)snapshot, usedHeap, committedHeap, totalDisk, usableDisk, minPing, maxPing, avgPing);
        }, this.asyncExecutor)).thenAcceptAsync(points -> {
            if (!points.isEmpty()) {
                try {
                    ServerPulseProvider.get().getDatabaseService().getWriteApi().writePoints((List<Point>)points);
                }
                catch (Exception e) {
                    this.logger.error("Error sending metrics to InfluxDB...", e);
                }
            }
        }, this.asyncExecutor)).exceptionally(ex -> {
            this.logger.error("Failed metrics pipeline stage...", (Throwable)ex);
            return null;
        });
    }

    private SyncMetricsSnapshot collectSnapshot() {
        if (!this.platform.isPrimaryThread()) {
            this.logger.warning("Skipping metrics send because the thread is not primary thread...");
            throw new IllegalStateException("This method must be called on the main thread.");
        }
        try {
            double[] tps = new double[]{0.0, 0.0, 0.0};
            int playerCount = this.platform.getOnlinePlayerCount();
            Map<String, WorldData> worldsData = null;
            try {
                tps = ServerPulseProvider.get().getTPSRetriever().getTPS();
                worldsData = this.platform.getWorldsData();
            }
            catch (UnsupportedOperationException e) {
                worldsData = Map.of();
            }
            return new SyncMetricsSnapshot(tps, playerCount, worldsData);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error during sync data collection: " + e.getMessage());
            throw new RuntimeException("Sync data collection failed...", e);
        }
    }

    private List<Point> buildPoints(SyncMetricsSnapshot snapshot, long usedHeap, long committedHeap, long totalDisk, long usableDisk, int minPing, int maxPing, int avgPing) {
        ArrayList<Point> points = new ArrayList<Point>();
        String serverTag = this.configuration.getServerTag();
        String measurement = this.configuration.getMeasurementTable();
        Point generalPoint = Point.measurement(measurement).addTag("server", serverTag).addField("tps_1m", snapshot.getTps()[0]).addField("tps_5m", snapshot.getTps()[1]).addField("tps_15m", snapshot.getTps()[2]).addField("players_online", snapshot.getPlayerCount()).addField("used_memory", usedHeap).addField("available_memory", committedHeap).addField("total_disk_space", totalDisk).addField("usable_disk_space", usableDisk).addField("min_ping", minPing).addField("max_ping", maxPing).addField("avg_ping", avgPing).time(Instant.now(), WritePrecision.NS);
        this.addConfigTags(generalPoint);
        points.add(generalPoint);
        for (Map.Entry<String, WorldData> entry : snapshot.getWorldData().entrySet()) {
            String worldName = entry.getKey();
            WorldData worldData = entry.getValue();
            Point worldPoint = Point.measurement(measurement).addTag("server", serverTag).addTag("world", worldName).addField("entities_count", worldData.getEntities()).addField("loaded_chunks", worldData.getLoadedChunks()).time(Instant.now(), WritePrecision.NS);
            this.addConfigTags(worldPoint);
            points.add(worldPoint);
        }
        return points;
    }

    private void addConfigTags(Point point) {
        Map<String, String> tags = this.configuration.getTags();
        tags.forEach(point::addTag);
    }

    private void loadTask() {
        long intervalTicks = 20L * this.configuration.getMetricsInterval();
        if (intervalTicks <= 0L) {
            this.logger.warning("Metrics interval is invalid, defaulting to 5 seconds.");
            intervalTicks = 100L;
        }
        this.scheduler.runTaskTimerAsync(this::collectAndSendMetrics, 0L, intervalTicks);
    }
}

