/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import it.renvins.serverpulse.api.ServerPulseProvider;
import it.renvins.serverpulse.api.metrics.IDiskRetriever;
import it.renvins.serverpulse.api.metrics.IPingRetriever;
import it.renvins.serverpulse.api.service.IDatabaseService;
import it.renvins.serverpulse.api.service.IMetricsService;
import it.renvins.serverpulse.common.DatabaseService;
import it.renvins.serverpulse.common.MetricsService;
import it.renvins.serverpulse.common.logger.PulseLogger;
import it.renvins.serverpulse.common.metrics.DiskRetriever;
import it.renvins.serverpulse.velocity.ServerPulseVelocityAPI;
import it.renvins.serverpulse.velocity.commands.ServerPulseCommand;
import it.renvins.serverpulse.velocity.config.VelocityConfiguration;
import it.renvins.serverpulse.velocity.config.VelocityDatabaseConfiguration;
import it.renvins.serverpulse.velocity.config.VelocityMetricsConfiguration;
import it.renvins.serverpulse.velocity.logger.VelocityLogger;
import it.renvins.serverpulse.velocity.metrics.VelocityPingRetriever;
import it.renvins.serverpulse.velocity.platform.VelocityPlatform;
import it.renvins.serverpulse.velocity.scheduler.VelocityTaskScheduler;
import java.nio.file.Path;
import lombok.Generated;
import org.slf4j.Logger;

@Plugin(id="serverpulse", name="ServerPulse", version="0.3.0-SNAPSHOT", description="Effortless Minecraft performance monitoring with pre-configured Grafana/InfluxDB via Docker.", authors={"renvins"})
public class ServerPulseVelocity {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private PulseLogger pulseLogger;
    private VelocityConfiguration config;
    private IDiskRetriever diskRetriever;
    private IPingRetriever pingRetriever;
    private IDatabaseService databaseService;
    private IMetricsService metricsService;

    @Inject
    public ServerPulseVelocity(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
        logger.info("ServerPulse for Fabric initialized - waiting for proxy starting...");
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.pulseLogger = new VelocityLogger(this.logger);
        this.config = new VelocityConfiguration(this.logger, this.dataDirectory, "config.yml");
        this.diskRetriever = new DiskRetriever(this.dataDirectory.toFile());
        this.pingRetriever = new VelocityPingRetriever(this);
        this.logger.info("Loading configuration file...");
        this.config.load();
        VelocityDatabaseConfiguration dbConfig = new VelocityDatabaseConfiguration(this.config);
        VelocityMetricsConfiguration metricsConfig = new VelocityMetricsConfiguration(this.config);
        VelocityPlatform platform = new VelocityPlatform(this);
        VelocityTaskScheduler scheduler = new VelocityTaskScheduler(this);
        this.databaseService = new DatabaseService(this.pulseLogger, platform, dbConfig, scheduler);
        this.metricsService = new MetricsService(this.pulseLogger, platform, metricsConfig, scheduler);
        ServerPulseProvider.register(new ServerPulseVelocityAPI(this.databaseService, this.metricsService, this.diskRetriever, this.pingRetriever));
        this.databaseService.load();
        if (this.server.isShuttingDown()) {
            return;
        }
        this.metricsService.load();
        CommandMeta meta = this.server.getCommandManager().metaBuilder("serverpulsevelocity").plugin((Object)this).aliases(new String[]{"spv"}).build();
        this.server.getCommandManager().register(meta, (Command)new ServerPulseCommand(this.config).createCommand());
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (this.databaseService != null) {
            this.databaseService.unload();
        }
        if (this.metricsService != null) {
            this.metricsService.unload();
        }
        try {
            ServerPulseProvider.unregister();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.logger.info("ServerPulse for Velocity has been shut down.");
    }

    @Generated
    public ProxyServer getServer() {
        return this.server;
    }
}

