/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Check;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.CheckDiscriminator;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.CustomCheck;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.DeadmanCheck;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.GreaterThreshold;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HTTPNotificationEndpoint;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HTTPNotificationRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LesserThreshold;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.NotificationEndpoint;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.NotificationEndpointDiscriminator;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.NotificationRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.NotificationRuleDiscriminator;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.PagerDutyNotificationEndpoint;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.PagerDutyNotificationRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.RangeThreshold;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.SMTPNotificationRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.SlackNotificationEndpoint;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.SlackNotificationRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.TelegramNotificationEndpoint;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.TelegramNotificationRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Threshold;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ThresholdCheck;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public class JSON {
    private Gson gson;

    public static GsonBuilder createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<Check>(Check.class, new LinkedHashMap<String, Class<? extends Check>>(){
            {
                this.put("deadman", DeadmanCheck.class);
                this.put("threshold", ThresholdCheck.class);
                this.put("custom", CustomCheck.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<CheckDiscriminator>(CheckDiscriminator.class, new LinkedHashMap<String, Class<? extends CheckDiscriminator>>(){
            {
                this.put("deadman", DeadmanCheck.class);
                this.put("threshold", ThresholdCheck.class);
                this.put("custom", CustomCheck.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<NotificationEndpoint>(NotificationEndpoint.class, new LinkedHashMap<String, Class<? extends NotificationEndpoint>>(){
            {
                this.put("slack", SlackNotificationEndpoint.class);
                this.put("pagerduty", PagerDutyNotificationEndpoint.class);
                this.put("http", HTTPNotificationEndpoint.class);
                this.put("telegram", TelegramNotificationEndpoint.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<NotificationEndpointDiscriminator>(NotificationEndpointDiscriminator.class, new LinkedHashMap<String, Class<? extends NotificationEndpointDiscriminator>>(){
            {
                this.put("slack", SlackNotificationEndpoint.class);
                this.put("pagerduty", PagerDutyNotificationEndpoint.class);
                this.put("http", HTTPNotificationEndpoint.class);
                this.put("telegram", TelegramNotificationEndpoint.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<NotificationRule>(NotificationRule.class, new LinkedHashMap<String, Class<? extends NotificationRule>>(){
            {
                this.put("slack", SlackNotificationRule.class);
                this.put("smtp", SMTPNotificationRule.class);
                this.put("pagerduty", PagerDutyNotificationRule.class);
                this.put("http", HTTPNotificationRule.class);
                this.put("telegram", TelegramNotificationRule.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<NotificationRuleDiscriminator>(NotificationRuleDiscriminator.class, new LinkedHashMap<String, Class<? extends NotificationRuleDiscriminator>>(){
            {
                this.put("slack", SlackNotificationRule.class);
                this.put("smtp", SMTPNotificationRule.class);
                this.put("pagerduty", PagerDutyNotificationRule.class);
                this.put("http", HTTPNotificationRule.class);
                this.put("telegram", TelegramNotificationRule.class);
            }
        }));
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<Threshold>(Threshold.class, new LinkedHashMap<String, Class<? extends Threshold>>(){
            {
                this.put("greater", GreaterThreshold.class);
                this.put("lesser", LesserThreshold.class);
                this.put("range", RangeThreshold.class);
            }
        }));
        return builder;
    }

    public JSON() {
        DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
        SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
        OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
        LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
        this.gson = JSON.createGson().registerTypeAdapter((Type)((Object)java.util.Date.class), dateTypeAdapter).registerTypeAdapter((Type)((Object)Date.class), sqlDateTypeAdapter).registerTypeAdapter((Type)((Object)OffsetDateTime.class), offsetDateTimeTypeAdapter).registerTypeAdapter((Type)((Object)LocalDate.class), localDateTypeAdapter).create();
    }

    public Gson getGson() {
        return this.gson;
    }

    public JSON setGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    static final class DiscriminatorAdapter<T>
    implements TypeAdapterFactory {
        private final Class<?> type;
        private final Map<String, Class<? extends T>> subTypes;
        private TypeAdapter<?> cachedAdapter;

        DiscriminatorAdapter(@Nonnull Class<T> type, @Nonnull Map<String, Class<? extends T>> subTypes) {
            Arguments.checkNotNull(type, "type");
            Arguments.checkNotNull(subTypes, "subTypes");
            this.type = type;
            this.subTypes = subTypes;
        }

        public <R> TypeAdapter<R> create(Gson gson, TypeToken<R> type) {
            if (type == null) {
                return null;
            }
            if (!this.type.isAssignableFrom(type.getRawType())) {
                return null;
            }
            if (this.cachedAdapter == null) {
                this.cachedAdapter = new InnerDiscriminatorAdapter(gson).nullSafe();
            }
            return this.cachedAdapter;
        }

        private class InnerDiscriminatorAdapter<R>
        extends TypeAdapter<R> {
            private final Gson gson;
            private final TypeAdapter<JsonElement> jsonAdapter;
            private final Map<String, TypeAdapter<?>> cachedSubtypesReadAdapters;
            private final Map<Class<?>, TypeAdapter<?>> cachedSubtypesWriteAdapters;

            InnerDiscriminatorAdapter(Gson gson) {
                Arguments.checkNotNull(gson, "gson");
                this.gson = gson;
                this.jsonAdapter = gson.getAdapter(JsonElement.class);
                this.cachedSubtypesReadAdapters = new LinkedHashMap();
                this.cachedSubtypesWriteAdapters = new LinkedHashMap();
                for (Map.Entry entry : DiscriminatorAdapter.this.subTypes.entrySet()) {
                    TypeAdapter adapter = gson.getDelegateAdapter(DiscriminatorAdapter.this, TypeToken.get(entry.getValue()));
                    this.cachedSubtypesReadAdapters.put(entry.getKey(), adapter);
                    this.cachedSubtypesWriteAdapters.put(entry.getValue(), adapter);
                }
            }

            @Override
            public R read(JsonReader in) throws IOException {
                JsonObject json = this.jsonAdapter.read(in).getAsJsonObject();
                JsonElement discriminatorJson = json.get("type");
                if (discriminatorJson == null) {
                    String msg = String.format("Cannot find JSON field 'type' for %s adapter. JSON value: '%s'", DiscriminatorAdapter.this.type, json);
                    throw new JsonParseException(msg);
                }
                String discriminator = discriminatorJson.getAsString();
                TypeAdapter<?> adapter = this.cachedSubtypesReadAdapters.get(discriminator);
                if (adapter == null) {
                    String msg = String.format("Cannot find model: '%s' for discriminator: '%s'. The discriminator wasn't registered.", discriminator, DiscriminatorAdapter.this.type);
                    throw new JsonParseException(msg);
                }
                return (R)adapter.fromJsonTree(json);
            }

            @Override
            public void write(JsonWriter out, R value) throws IOException {
                Class<?> outputType = value.getClass();
                TypeAdapter<?> adapter = this.cachedSubtypesWriteAdapters.get(outputType);
                if (adapter == null) {
                    adapter = this.gson.getDelegateAdapter(DiscriminatorAdapter.this, TypeToken.get(outputType));
                    this.cachedSubtypesWriteAdapters.put(DiscriminatorAdapter.this.type, adapter);
                }
                this.jsonAdapter.write(out, adapter.toJsonTree(value).getAsJsonObject());
            }
        }
    }

    public static class DateTypeAdapter
    extends TypeAdapter<java.util.Date> {
        private DateFormat dateFormat;

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.util.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : ISO8601Utils.format(date, true);
                out.value(value);
            }
        }

        @Override
        public java.util.Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL: {
                        in.nextNull();
                        return null;
                    }
                }
                String date = in.nextString();
                try {
                    if (this.dateFormat != null) {
                        return this.dateFormat.parse(date);
                    }
                    return ISO8601Utils.parse(date, new ParsePosition(0));
                }
                catch (ParseException e) {
                    throw new JsonParseException(e);
                }
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static class SqlDateTypeAdapter
    extends TypeAdapter<Date> {
        private DateFormat dateFormat;

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value = this.dateFormat != null ? this.dateFormat.format(date) : date.toString();
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            try {
                if (this.dateFormat != null) {
                    return new Date(this.dateFormat.parse(date).getTime());
                }
                return new Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
            }
            catch (ParseException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        private static final OffsetDateTime ZERO = LocalDateTime.of(0, 1, 1, 0, 0).atOffset(ZoneOffset.UTC);
        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                if (date.getYear() > 9999 || date.isBefore(ZERO)) {
                    throw new JsonIOException("OffsetDateTime is out of range. All dates and times are assumed to be in the \"current era\", somewhere between 0000AD and 9999AD.");
                }
                out.value(this.formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            Object date = in.nextString();
            if (((String)date).endsWith("+0000")) {
                date = ((String)date).substring(0, ((String)date).length() - 5) + "Z";
            }
            return OffsetDateTime.parse((CharSequence)date, this.formatter);
        }
    }

    public class LocalDateTypeAdapter
    extends TypeAdapter<LocalDate> {
        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(this.formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL: {
                    in.nextNull();
                    return null;
                }
            }
            String date = in.nextString();
            return LocalDate.parse(date, this.formatter);
        }
    }
}

