/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.annotation.concurrent.NotThreadSafe;
import it.renvins.serverpulse.velocity.libs.annotation.concurrent.ThreadSafe;
import it.renvins.serverpulse.velocity.libs.influxdb.client.WriteApi;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.BackpressureOverflowStrategy;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Scheduler;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.schedulers.Schedulers;

@ThreadSafe
public final class WriteOptions
implements WriteApi.RetryOptions {
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final int DEFAULT_FLUSH_INTERVAL = 1000;
    public static final int DEFAULT_JITTER_INTERVAL = 0;
    public static final int DEFAULT_RETRY_INTERVAL = 5000;
    public static final int DEFAULT_MAX_RETRIES = 5;
    public static final int DEFAULT_MAX_RETRY_DELAY = 125000;
    public static final int DEFAULT_MAX_RETRY_TIME = 180000;
    public static final int DEFAULT_EXPONENTIAL_BASE = 2;
    public static final int DEFAULT_BUFFER_LIMIT = 10000;
    public static final WriteOptions DEFAULTS = WriteOptions.builder().build();
    private final int batchSize;
    private final int flushInterval;
    private final int jitterInterval;
    private final int retryInterval;
    private final int maxRetries;
    private final int maxRetryDelay;
    private final int maxRetryTime;
    private final int exponentialBase;
    private final int bufferLimit;
    private final Scheduler writeScheduler;
    private final BackpressureOverflowStrategy backpressureStrategy;

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    @Override
    public int getJitterInterval() {
        return this.jitterInterval;
    }

    @Override
    public int getRetryInterval() {
        return this.retryInterval;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public int getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public int getMaxRetryTime() {
        return this.maxRetryTime;
    }

    @Override
    public int getExponentialBase() {
        return this.exponentialBase;
    }

    public int getBufferLimit() {
        return this.bufferLimit;
    }

    @Nonnull
    public Scheduler getWriteScheduler() {
        return this.writeScheduler;
    }

    @Nonnull
    public BackpressureOverflowStrategy getBackpressureStrategy() {
        return this.backpressureStrategy;
    }

    private WriteOptions(@Nonnull Builder builder) {
        Arguments.checkNotNull(builder, "WriteOptions.Builder");
        this.batchSize = builder.batchSize;
        this.flushInterval = builder.flushInterval;
        this.jitterInterval = builder.jitterInterval;
        this.retryInterval = builder.retryInterval;
        this.maxRetries = builder.maxRetries;
        this.maxRetryDelay = builder.maxRetryDelay;
        this.maxRetryTime = builder.maxRetryTime;
        this.exponentialBase = builder.exponentialBase;
        this.bufferLimit = builder.bufferLimit;
        this.writeScheduler = builder.writeScheduler;
        this.backpressureStrategy = builder.backpressureStrategy;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static class Builder {
        private int batchSize = 1000;
        private int flushInterval = 1000;
        private int jitterInterval = 0;
        private int retryInterval = 5000;
        private int maxRetries = 5;
        private int maxRetryDelay = 125000;
        private int maxRetryTime = 180000;
        private int exponentialBase = 2;
        private int bufferLimit = 10000;
        private Scheduler writeScheduler = Schedulers.newThread();
        private BackpressureOverflowStrategy backpressureStrategy = BackpressureOverflowStrategy.DROP_OLDEST;

        @Nonnull
        public Builder batchSize(int batchSize) {
            Arguments.checkPositiveNumber(batchSize, "batchSize");
            this.batchSize = batchSize;
            return this;
        }

        @Nonnull
        public Builder flushInterval(int flushInterval) {
            Arguments.checkPositiveNumber(flushInterval, "flushInterval");
            this.flushInterval = flushInterval;
            return this;
        }

        @Nonnull
        public Builder jitterInterval(int jitterInterval) {
            Arguments.checkNotNegativeNumber(jitterInterval, "jitterInterval");
            this.jitterInterval = jitterInterval;
            return this;
        }

        @Nonnull
        public Builder retryInterval(int retryInterval) {
            Arguments.checkPositiveNumber(retryInterval, "retryInterval");
            this.retryInterval = retryInterval;
            return this;
        }

        @Nonnull
        public Builder maxRetries(int maxRetries) {
            Arguments.checkPositiveNumber(maxRetries, "maxRetries");
            this.maxRetries = maxRetries;
            return this;
        }

        @Nonnull
        public Builder maxRetryDelay(int maxRetryDelay) {
            Arguments.checkPositiveNumber(maxRetryDelay, "maxRetryDelay");
            this.maxRetryDelay = maxRetryDelay;
            return this;
        }

        @Nonnull
        public Builder maxRetryTime(int maxRetryTime) {
            Arguments.checkPositiveNumber(maxRetryTime, "maxRetryTime");
            this.maxRetryTime = maxRetryTime;
            return this;
        }

        @Nonnull
        public Builder exponentialBase(int exponentialBase) {
            Arguments.checkPositiveNumber(exponentialBase, "exponentialBase");
            this.exponentialBase = exponentialBase;
            return this;
        }

        @Nonnull
        public Builder bufferLimit(int bufferLimit) {
            Arguments.checkNotNegativeNumber(bufferLimit, "bufferLimit");
            this.bufferLimit = bufferLimit;
            return this;
        }

        @Nonnull
        public Builder writeScheduler(@Nonnull Scheduler writeScheduler) {
            Arguments.checkNotNull(writeScheduler, "Write scheduler");
            this.writeScheduler = writeScheduler;
            return this;
        }

        @Nonnull
        public Builder backpressureStrategy(@Nonnull BackpressureOverflowStrategy backpressureStrategy) {
            Arguments.checkNotNull((Object)backpressureStrategy, "Backpressure Overflow Strategy");
            this.backpressureStrategy = backpressureStrategy;
            return this;
        }

        @Nonnull
        public WriteOptions build() {
            return new WriteOptions(this);
        }
    }
}

