/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum AxisScale {
    LOG("log"),
    LINEAR("linear");

    private String value;

    private AxisScale(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AxisScale fromValue(String text) {
        for (AxisScale b : AxisScale.values()) {
            if (!String.valueOf(b.value).equals(text)) continue;
            return b;
        }
        return null;
    }

    public static class Adapter
    extends TypeAdapter<AxisScale> {
        @Override
        public void write(JsonWriter jsonWriter, AxisScale enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        @Override
        public AxisScale read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return AxisScale.fromValue(String.valueOf(value));
        }
    }
}

