/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Dialect {
    public static final String SERIALIZED_NAME_HEADER = "header";
    @SerializedName(value="header")
    private Boolean header = true;
    public static final String SERIALIZED_NAME_DELIMITER = "delimiter";
    @SerializedName(value="delimiter")
    private String delimiter = ",";
    public static final String SERIALIZED_NAME_ANNOTATIONS = "annotations";
    @SerializedName(value="annotations")
    private List<AnnotationsEnum> annotations = new ArrayList<AnnotationsEnum>();
    public static final String SERIALIZED_NAME_COMMENT_PREFIX = "commentPrefix";
    @SerializedName(value="commentPrefix")
    private String commentPrefix = "#";
    public static final String SERIALIZED_NAME_DATE_TIME_FORMAT = "dateTimeFormat";
    @SerializedName(value="dateTimeFormat")
    private DateTimeFormatEnum dateTimeFormat = DateTimeFormatEnum.RFC3339;

    public Dialect header(Boolean header) {
        this.header = header;
        return this;
    }

    public Boolean getHeader() {
        return this.header;
    }

    public void setHeader(Boolean header) {
        this.header = header;
    }

    public Dialect delimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Dialect annotations(List<AnnotationsEnum> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Dialect addAnnotationsItem(AnnotationsEnum annotationsItem) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AnnotationsEnum>();
        }
        this.annotations.add(annotationsItem);
        return this;
    }

    public List<AnnotationsEnum> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationsEnum> annotations) {
        this.annotations = annotations;
    }

    public Dialect commentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
        return this;
    }

    public String getCommentPrefix() {
        return this.commentPrefix;
    }

    public void setCommentPrefix(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    public Dialect dateTimeFormat(DateTimeFormatEnum dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        return this;
    }

    public DateTimeFormatEnum getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(DateTimeFormatEnum dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dialect dialect = (Dialect)o;
        return Objects.equals(this.header, dialect.header) && Objects.equals(this.delimiter, dialect.delimiter) && Objects.equals(this.annotations, dialect.annotations) && Objects.equals(this.commentPrefix, dialect.commentPrefix) && Objects.equals((Object)this.dateTimeFormat, (Object)dialect.dateTimeFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.header, this.delimiter, this.annotations, this.commentPrefix, this.dateTimeFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Dialect {\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("    delimiter: ").append(this.toIndentedString(this.delimiter)).append("\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    commentPrefix: ").append(this.toIndentedString(this.commentPrefix)).append("\n");
        sb.append("    dateTimeFormat: ").append(this.toIndentedString((Object)this.dateTimeFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DateTimeFormatEnum {
        RFC3339("RFC3339"),
        RFC3339NANO("RFC3339Nano");

        private String value;

        private DateTimeFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DateTimeFormatEnum fromValue(String text) {
            for (DateTimeFormatEnum b : DateTimeFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DateTimeFormatEnum> {
            @Override
            public void write(JsonWriter jsonWriter, DateTimeFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public DateTimeFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DateTimeFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AnnotationsEnum {
        GROUP("group"),
        DATATYPE("datatype"),
        DEFAULT("default");

        private String value;

        private AnnotationsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AnnotationsEnum fromValue(String text) {
            for (AnnotationsEnum b : AnnotationsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AnnotationsEnum> {
            @Override
            public void write(JsonWriter jsonWriter, AnnotationsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public AnnotationsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AnnotationsEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

