/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.domain;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class InfluxQLQuery {
    private final String command;
    private final String database;
    private String retentionPolicy;
    private InfluxQLPrecision precision;
    private AcceptHeader acceptHeader;

    public InfluxQLQuery(@Nonnull String command, @Nonnull String database) {
        this.command = command;
        this.database = database;
        this.acceptHeader = AcceptHeader.CSV;
    }

    public InfluxQLQuery(@Nonnull String command, @Nonnull String database, @Nonnull AcceptHeader acceptHeader) {
        this.command = command;
        this.database = database;
        this.acceptHeader = acceptHeader;
    }

    @Nonnull
    public String getCommand() {
        return this.command;
    }

    @Nonnull
    public String getDatabase() {
        return this.database;
    }

    @Nullable
    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    @Nonnull
    public InfluxQLQuery setRetentionPolicy(@Nullable String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    @Nullable
    public InfluxQLPrecision getPrecision() {
        return this.precision;
    }

    @Nonnull
    public InfluxQLQuery setPrecision(@Nullable InfluxQLPrecision precision) {
        this.precision = precision;
        return this;
    }

    public AcceptHeader getAcceptHeader() {
        return this.acceptHeader;
    }

    public InfluxQLQuery setAcceptHeader(AcceptHeader acceptHeader) {
        this.acceptHeader = acceptHeader;
        return this;
    }

    public String getAcceptHeaderVal() {
        return this.acceptHeader != null ? this.acceptHeader.getVal() : AcceptHeader.CSV.getVal();
    }

    public static enum AcceptHeader {
        JSON("application/json"),
        CSV("application/csv");

        private final String val;

        private AcceptHeader(String val) {
            this.val = val;
        }

        public String getVal() {
            return this.val;
        }
    }

    public static enum InfluxQLPrecision {
        HOURS("h"),
        MINUTES("m"),
        SECONDS("s"),
        MILLISECONDS("ms"),
        MICROSECONDS("u"),
        NANOSECONDS("n");

        private final String symbol;

        private InfluxQLPrecision(String symbol) {
            this.symbol = symbol;
        }

        @Nonnull
        public String getSymbol() {
            return this.symbol;
        }

        @Nonnull
        public static InfluxQLPrecision toTimePrecision(TimeUnit t) {
            switch (t) {
                case HOURS: {
                    return HOURS;
                }
                case MINUTES: {
                    return MINUTES;
                }
                case SECONDS: {
                    return SECONDS;
                }
                case MILLISECONDS: {
                    return MILLISECONDS;
                }
                case MICROSECONDS: {
                    return MICROSECONDS;
                }
                case NANOSECONDS: {
                    return NANOSECONDS;
                }
            }
            throw new IllegalArgumentException("time precision must be one of:" + Arrays.toString((Object[])InfluxQLPrecision.values()));
        }
    }
}

