/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.domain;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.BandViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.CheckViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.GaugeViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HeatmapViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HistogramViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LinePlusSingleStatProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.MarkdownViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.MosaicViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ScatterViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.SimpleTableViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.SingleStatViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.TableViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.XYViewProperties;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TemplateChart {
    public static final String SERIALIZED_NAME_X_POS = "xPos";
    @SerializedName(value="xPos")
    private Integer xPos;
    public static final String SERIALIZED_NAME_Y_POS = "yPos";
    @SerializedName(value="yPos")
    private Integer yPos;
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private Integer height;
    public static final String SERIALIZED_NAME_WIDTH = "width";
    @SerializedName(value="width")
    private Integer width;
    public static final String SERIALIZED_NAME_PROPERTIES = "properties";
    @SerializedName(value="properties")
    @JsonAdapter(value=TemplateChartPropertiesAdapter.class)
    private ViewProperties properties = null;

    public TemplateChart xPos(Integer xPos) {
        this.xPos = xPos;
        return this;
    }

    public Integer getXPos() {
        return this.xPos;
    }

    public void setXPos(Integer xPos) {
        this.xPos = xPos;
    }

    public TemplateChart yPos(Integer yPos) {
        this.yPos = yPos;
        return this;
    }

    public Integer getYPos() {
        return this.yPos;
    }

    public void setYPos(Integer yPos) {
        this.yPos = yPos;
    }

    public TemplateChart height(Integer height) {
        this.height = height;
        return this;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public TemplateChart width(Integer width) {
        this.width = width;
        return this;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public TemplateChart properties(ViewProperties properties) {
        this.properties = properties;
        return this;
    }

    public ViewProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ViewProperties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateChart templateChart = (TemplateChart)o;
        return Objects.equals(this.xPos, templateChart.xPos) && Objects.equals(this.yPos, templateChart.yPos) && Objects.equals(this.height, templateChart.height) && Objects.equals(this.width, templateChart.width) && Objects.equals(this.properties, templateChart.properties);
    }

    public int hashCode() {
        return Objects.hash(this.xPos, this.yPos, this.height, this.width, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TemplateChart {\n");
        sb.append("    xPos: ").append(this.toIndentedString(this.xPos)).append("\n");
        sb.append("    yPos: ").append(this.toIndentedString(this.yPos)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class TemplateChartPropertiesAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        @Override
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList("timeFormat", "type", "shape");
            JsonObject jsonObject = json.getAsJsonObject();
            String[] types = (String[])discriminator.stream().map(jsonObject::get).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);
            return this.deserialize(types, jsonObject, context);
        }

        @Override
        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"LinePlusSingleStatProperties", "line-plus-single-stat", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)LinePlusSingleStatProperties.class));
            }
            if (Arrays.equals(new String[]{"XYViewProperties", "xy", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)XYViewProperties.class));
            }
            if (Arrays.equals(new String[]{"single-stat", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)SingleStatViewProperties.class));
            }
            if (Arrays.equals(new String[]{"histogram", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)HistogramViewProperties.class));
            }
            if (Arrays.equals(new String[]{"gauge", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)GaugeViewProperties.class));
            }
            if (Arrays.equals(new String[]{"table", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)TableViewProperties.class));
            }
            if (Arrays.equals(new String[]{"simple-table", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)SimpleTableViewProperties.class));
            }
            if (Arrays.equals(new String[]{"markdown", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)MarkdownViewProperties.class));
            }
            if (Arrays.equals(new String[]{"check", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)CheckViewProperties.class));
            }
            if (Arrays.equals(new String[]{"ScatterViewProperties", "scatter", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)ScatterViewProperties.class));
            }
            if (Arrays.equals(new String[]{"HeatmapViewProperties", "heatmap", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)HeatmapViewProperties.class));
            }
            if (Arrays.equals(new String[]{"MosaicViewProperties", "mosaic", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)MosaicViewProperties.class));
            }
            if (Arrays.equals(new String[]{"BandViewProperties", "band", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)BandViewProperties.class));
            }
            return context.deserialize(json, (Type)((Object)Object.class));
        }
    }
}

