/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.domain;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.BandViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.CheckViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.GaugeViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HeatmapViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HistogramViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LinePlusSingleStatProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.MarkdownViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.MosaicViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ScatterViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.SimpleTableViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.SingleStatViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.TableViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ViewLinks;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ViewProperties;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.XYViewProperties;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class View {
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private ViewLinks links = null;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PROPERTIES = "properties";
    @SerializedName(value="properties")
    @JsonAdapter(value=ViewPropertiesAdapter.class)
    private ViewProperties properties = null;

    public View links(ViewLinks links) {
        this.links = links;
        return this;
    }

    public ViewLinks getLinks() {
        return this.links;
    }

    public void setLinks(ViewLinks links) {
        this.links = links;
    }

    public String getId() {
        return this.id;
    }

    public View name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public View properties(ViewProperties properties) {
        this.properties = properties;
        return this;
    }

    public ViewProperties getProperties() {
        return this.properties;
    }

    public void setProperties(ViewProperties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View view = (View)o;
        return Objects.equals(this.links, view.links) && Objects.equals(this.id, view.id) && Objects.equals(this.name, view.name) && Objects.equals(this.properties, view.properties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.name, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class View {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class ViewPropertiesAdapter
    implements JsonDeserializer<Object>,
    JsonSerializer<Object> {
        @Override
        public Object deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<String> discriminator = Arrays.asList("timeFormat", "type", "shape");
            JsonObject jsonObject = json.getAsJsonObject();
            String[] types = (String[])discriminator.stream().map(jsonObject::get).filter(Objects::nonNull).map(JsonElement::getAsString).toArray(String[]::new);
            return this.deserialize(types, jsonObject, context);
        }

        @Override
        public JsonElement serialize(Object object, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize(object);
        }

        private Object deserialize(String[] types, JsonElement json, JsonDeserializationContext context) {
            if (Arrays.equals(new String[]{"LinePlusSingleStatProperties", "line-plus-single-stat", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)LinePlusSingleStatProperties.class));
            }
            if (Arrays.equals(new String[]{"XYViewProperties", "xy", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)XYViewProperties.class));
            }
            if (Arrays.equals(new String[]{"single-stat", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)SingleStatViewProperties.class));
            }
            if (Arrays.equals(new String[]{"histogram", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)HistogramViewProperties.class));
            }
            if (Arrays.equals(new String[]{"gauge", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)GaugeViewProperties.class));
            }
            if (Arrays.equals(new String[]{"table", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)TableViewProperties.class));
            }
            if (Arrays.equals(new String[]{"simple-table", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)SimpleTableViewProperties.class));
            }
            if (Arrays.equals(new String[]{"markdown", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)MarkdownViewProperties.class));
            }
            if (Arrays.equals(new String[]{"check", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)CheckViewProperties.class));
            }
            if (Arrays.equals(new String[]{"ScatterViewProperties", "scatter", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)ScatterViewProperties.class));
            }
            if (Arrays.equals(new String[]{"HeatmapViewProperties", "heatmap", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)HeatmapViewProperties.class));
            }
            if (Arrays.equals(new String[]{"MosaicViewProperties", "mosaic", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)MosaicViewProperties.class));
            }
            if (Arrays.equals(new String[]{"BandViewProperties", "band", "chronograf-v2"}, types)) {
                return context.deserialize(json, (Type)((Object)BandViewProperties.class));
            }
            return context.deserialize(json, (Type)((Object)Object.class));
        }
    }
}

