/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.influxdb.client.InfluxDBClientOptions;
import it.renvins.serverpulse.velocity.libs.influxdb.client.JSON;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Dialect;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HealthCheck;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.AuthenticateInterceptor;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.GzipInterceptor;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.HealthService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.PingService;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.InfluxException;
import it.renvins.serverpulse.velocity.libs.influxdb.internal.AbstractRestClient;
import it.renvins.serverpulse.velocity.libs.influxdb.internal.UserAgentInterceptor;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.okhttp3.OkHttpClient;
import it.renvins.serverpulse.velocity.libs.okhttp3.logging.HttpLoggingInterceptor;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import it.renvins.serverpulse.velocity.libs.retrofit2.CallAdapter;
import it.renvins.serverpulse.velocity.libs.retrofit2.Retrofit;
import it.renvins.serverpulse.velocity.libs.retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import it.renvins.serverpulse.velocity.libs.retrofit2.converter.gson.GsonConverterFactory;
import it.renvins.serverpulse.velocity.libs.retrofit2.converter.scalars.ScalarsConverterFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractInfluxDBClient
extends AbstractRestClient {
    private static final Logger LOG = Logger.getLogger(AbstractInfluxDBClient.class.getName());
    public static final Dialect DEFAULT_DIALECT = new Dialect().header(true).delimiter(",").commentPrefix("#").addAnnotationsItem(Dialect.AnnotationsEnum.DATATYPE).addAnnotationsItem(Dialect.AnnotationsEnum.GROUP).addAnnotationsItem(Dialect.AnnotationsEnum.DEFAULT);
    public final HealthService healthService;
    public final PingService pingService;
    protected final Retrofit retrofit;
    protected final InfluxDBClientOptions options;
    protected final HttpLoggingInterceptor loggingInterceptor;
    protected final GzipInterceptor gzipInterceptor;
    private final AuthenticateInterceptor authenticateInterceptor;
    private final OkHttpClient okHttpClient;
    protected final Collection<AutoCloseable> autoCloseables = new CopyOnWriteArrayList<AutoCloseable>();

    public AbstractInfluxDBClient(@Nonnull InfluxDBClientOptions options, @Nonnull String clientType) {
        this(options, clientType, Collections.singletonList(RxJava3CallAdapterFactory.createSynchronous()));
    }

    public AbstractInfluxDBClient(@Nonnull InfluxDBClientOptions options, @Nonnull String clientType, @Nonnull Collection<CallAdapter.Factory> factories) {
        Arguments.checkNotNull(options, "InfluxDBClientOptions");
        Arguments.checkNotNull(factories, "factories");
        Arguments.checkNonEmpty(clientType, "clientType");
        this.options = options;
        this.loggingInterceptor = new HttpLoggingInterceptor();
        this.loggingInterceptor.redactHeader("Authorization");
        this.setLogLevel(this.loggingInterceptor, options.getLogLevel());
        this.authenticateInterceptor = new AuthenticateInterceptor(options);
        this.gzipInterceptor = new GzipInterceptor();
        String customClientType = options.getClientType() != null ? options.getClientType() : clientType;
        this.okHttpClient = options.getOkHttpClient().addInterceptor(new UserAgentInterceptor(customClientType)).addInterceptor(this.authenticateInterceptor).addInterceptor(this.loggingInterceptor).addInterceptor(this.gzipInterceptor).build();
        this.authenticateInterceptor.initToken(this.okHttpClient);
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(options.getUrl()).client(this.okHttpClient).addConverterFactory(ScalarsConverterFactory.create()).addConverterFactory(GsonConverterFactory.create(new JSON().getGson()));
        for (CallAdapter.Factory factory2 : factories) {
            retrofitBuilder.addCallAdapterFactory(factory2);
        }
        this.retrofit = retrofitBuilder.build();
        this.healthService = this.retrofit.create(HealthService.class);
        this.pingService = this.retrofit.create(PingService.class);
    }

    public void close() {
        this.autoCloseables.stream().filter(Objects::nonNull).forEach(resource -> {
            try {
                resource.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, String.format("Exception was thrown while closing: %s", resource), e);
            }
        });
        this.autoCloseables.clear();
        try {
            this.authenticateInterceptor.signout();
        }
        catch (IOException e) {
            LOG.log(Level.FINEST, "The signout exception", e);
        }
        this.okHttpClient.connectionPool().evictAll();
        this.okHttpClient.dispatcher().executorService().shutdown();
    }

    @Nonnull
    protected HealthCheck health(Call<HealthCheck> healthCall) {
        Arguments.checkNotNull(healthCall, "health call");
        try {
            return this.execute(healthCall);
        }
        catch (InfluxException e) {
            HealthCheck health = new HealthCheck();
            health.setName("influxdb");
            health.setStatus(HealthCheck.StatusEnum.FAIL);
            health.setMessage(e.getMessage());
            return health;
        }
    }
}

