/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.influxdb.client.InfluxDBClientOptions;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.InfluxDBClientImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.okhttp3.Credentials;
import it.renvins.serverpulse.velocity.libs.okhttp3.HttpUrl;
import it.renvins.serverpulse.velocity.libs.okhttp3.Interceptor;
import it.renvins.serverpulse.velocity.libs.okhttp3.OkHttpClient;
import it.renvins.serverpulse.velocity.libs.okhttp3.Request;
import it.renvins.serverpulse.velocity.libs.okhttp3.RequestBody;
import it.renvins.serverpulse.velocity.libs.okhttp3.Response;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

class AuthenticateInterceptor
implements Interceptor {
    private static final Logger LOG = Logger.getLogger(InfluxDBClientImpl.class.getName());
    private static final List<String> NO_AUTH_ROUTE = Arrays.asList("/api/v2/signin", "/api/v2/signout", "/api/v2/setup");
    private final InfluxDBClientOptions influxDBClientOptions;
    private OkHttpClient okHttpClient;
    private char[] sessionCookies;
    private final AtomicBoolean signout = new AtomicBoolean(false);

    AuthenticateInterceptor(@Nonnull InfluxDBClientOptions influxDBClientOptions) {
        Arguments.checkNotNull(influxDBClientOptions, "InfluxDBClientOptions");
        this.influxDBClientOptions = influxDBClientOptions;
    }

    @Override
    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String requestPath = request.url().encodedPath();
        if (NO_AUTH_ROUTE.stream().anyMatch(requestPath::endsWith)) {
            return chain.proceed(request);
        }
        if (this.signout.get()) {
            LOG.log(Level.WARNING, "Authorization interception failed. Already signed out.");
            return chain.proceed(request);
        }
        if (InfluxDBClientOptions.AuthScheme.TOKEN.equals((Object)this.influxDBClientOptions.getAuthScheme())) {
            request = request.newBuilder().header("Authorization", "Token " + this.string(this.influxDBClientOptions.getToken())).build();
        } else if (InfluxDBClientOptions.AuthScheme.SESSION.equals((Object)this.influxDBClientOptions.getAuthScheme())) {
            this.initToken(this.okHttpClient);
            if (this.sessionCookies != null) {
                request = request.newBuilder().header("Cookie", this.string(this.sessionCookies)).build();
            }
        }
        return chain.proceed(request);
    }

    void initToken(@Nonnull OkHttpClient okHttpClient) {
        Arguments.checkNotNull(okHttpClient, "okHttpClient");
        this.okHttpClient = okHttpClient;
        if (!InfluxDBClientOptions.AuthScheme.SESSION.equals((Object)this.influxDBClientOptions.getAuthScheme()) || this.signout.get()) {
            return;
        }
        if (this.sessionCookies == null) {
            String credentials = Credentials.basic(this.influxDBClientOptions.getUsername(), this.string(this.influxDBClientOptions.getPassword()));
            Request authRequest = new Request.Builder().url(this.buildPath("api/v2/signin")).addHeader("Authorization", credentials).post(RequestBody.create("application/json", null)).build();
            try (Response authResponse = this.okHttpClient.newCall(authRequest).execute();){
                String cookieHeader = authResponse.headers().get("Set-Cookie");
                if (cookieHeader != null) {
                    this.sessionCookies = cookieHeader.toCharArray();
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Cannot retrieve the Session token!", e);
            }
        }
    }

    void signout() throws IOException {
        if (!InfluxDBClientOptions.AuthScheme.SESSION.equals((Object)this.influxDBClientOptions.getAuthScheme()) || this.signout.get()) {
            this.signout.set(true);
            return;
        }
        Request.Builder authRequest = new Request.Builder().url(this.buildPath("api/v2/signout")).post(RequestBody.create("application/json", null));
        if (this.sessionCookies != null) {
            authRequest.addHeader("Cookie", this.string(this.sessionCookies));
        }
        this.signout.set(true);
        this.sessionCookies = null;
        Response response = this.okHttpClient.newCall(authRequest.build()).execute();
        response.close();
    }

    @Nonnull
    String buildPath(String buildPath) {
        Arguments.checkNotNull(buildPath, "buildPath");
        return HttpUrl.parse(this.influxDBClientOptions.getUrl()).newBuilder().addEncodedPathSegments(buildPath).build().toString();
    }

    @Nonnull
    private String string(char[] password) {
        return String.valueOf(password);
    }
}

