/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.influxdb.LogLevel;
import it.renvins.serverpulse.velocity.libs.influxdb.client.AuthorizationsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.BucketsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.ChecksApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.DashboardsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.DeleteApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.InfluxDBClient;
import it.renvins.serverpulse.velocity.libs.influxdb.client.InfluxDBClientOptions;
import it.renvins.serverpulse.velocity.libs.influxdb.client.InfluxQLQueryApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.InvokableScriptsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.LabelsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.NotificationEndpointsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.NotificationRulesApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.OrganizationsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.QueryApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.ScraperTargetsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.SourcesApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.TasksApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.TelegrafsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.UsersApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.VariablesApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.WriteApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.WriteApiBlocking;
import it.renvins.serverpulse.velocity.libs.influxdb.client.WriteOptions;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HealthCheck;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.IsOnboarding;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.OnboardingRequest;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.OnboardingResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Ready;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.AbstractInfluxDBClient;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.AuthorizationsApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.BucketsApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.ChecksApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.DashboardsApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.DeleteApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.InfluxQLQueryApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.InvokableScriptsApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.LabelsApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.NotificationEndpointsApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.NotificationRulesApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.OrganizationsApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.QueryApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.ScraperTargetsApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.SourcesApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.TasksApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.TelegrafsApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.UsersApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.VariablesApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.WriteApiBlockingImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.WriteApiImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.AuthorizationsService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.BucketsService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.ChecksService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.DashboardsService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.DeleteService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.InfluxQLQueryService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.InvokableScriptsService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.LabelsService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.NotificationEndpointsService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.NotificationRulesService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.OrganizationsService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.QueryService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.ReadyService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.ScraperTargetsService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.SecretsService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.SetupService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.SourcesService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.TasksService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.TelegrafsService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.UsersService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.VariablesService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.WriteService;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.InfluxException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.UnprocessableEntityException;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class InfluxDBClientImpl
extends AbstractInfluxDBClient
implements InfluxDBClient {
    private static final Logger LOG = Logger.getLogger(InfluxDBClientImpl.class.getName());
    private final SetupService setupService;
    private final ReadyService readyService;

    public InfluxDBClientImpl(@Nonnull InfluxDBClientOptions options) {
        super(options, "java");
        this.setupService = this.retrofit.create(SetupService.class);
        this.readyService = this.retrofit.create(ReadyService.class);
    }

    @Override
    @Nonnull
    public QueryApi getQueryApi() {
        return new QueryApiImpl(this.retrofit.create(QueryService.class), this.options);
    }

    @Override
    @Nonnull
    public WriteApi getWriteApi() {
        return this.makeWriteApi();
    }

    @Override
    @Nonnull
    public WriteApi getWriteApi(@Nonnull WriteOptions writeOptions) {
        Arguments.checkNotNull(writeOptions, "WriteOptions");
        return this.makeWriteApi(writeOptions);
    }

    @Override
    @Nonnull
    public WriteApi makeWriteApi() {
        return this.makeWriteApi(WriteOptions.DEFAULTS);
    }

    @Override
    @Nonnull
    public WriteApi makeWriteApi(@Nonnull WriteOptions writeOptions) {
        Arguments.checkNotNull(writeOptions, "WriteOptions");
        if (this.autoCloseables.size() >= 10) {
            String format = "There is already created %d instances of 'WriteApi'. The 'WriteApi' is suppose to run as a singleton and should be reused across threads. Use 'WriteApiBlocking` if you would like to use one-time ingesting.";
            LOG.warning(String.format(format, this.autoCloseables.size()));
        }
        return new WriteApiImpl(writeOptions, this.retrofit.create(WriteService.class), this.options, this.autoCloseables);
    }

    @Override
    @Nonnull
    public WriteApiBlocking getWriteApiBlocking() {
        return new WriteApiBlockingImpl(this.retrofit.create(WriteService.class), this.options);
    }

    @Override
    @Nonnull
    public AuthorizationsApi getAuthorizationsApi() {
        return new AuthorizationsApiImpl(this.retrofit.create(AuthorizationsService.class));
    }

    @Override
    @Nonnull
    public BucketsApi getBucketsApi() {
        return new BucketsApiImpl(this.retrofit.create(BucketsService.class));
    }

    @Override
    @Nonnull
    public OrganizationsApi getOrganizationsApi() {
        return new OrganizationsApiImpl(this.retrofit.create(OrganizationsService.class), this.retrofit.create(SecretsService.class));
    }

    @Override
    @Nonnull
    public SourcesApi getSourcesApi() {
        return new SourcesApiImpl(this.retrofit.create(SourcesService.class), this);
    }

    @Override
    @Nonnull
    public TasksApi getTasksApi() {
        return new TasksApiImpl(this.retrofit.create(TasksService.class));
    }

    @Override
    @Nonnull
    public UsersApi getUsersApi() {
        return new UsersApiImpl(this.retrofit.create(UsersService.class));
    }

    @Override
    @Nonnull
    public ScraperTargetsApi getScraperTargetsApi() {
        return new ScraperTargetsApiImpl(this.retrofit.create(ScraperTargetsService.class));
    }

    @Override
    @Nonnull
    public TelegrafsApi getTelegrafsApi() {
        return new TelegrafsApiImpl(this.retrofit.create(TelegrafsService.class));
    }

    @Override
    @Nonnull
    public LabelsApi getLabelsApi() {
        return new LabelsApiImpl(this.retrofit.create(LabelsService.class));
    }

    @Override
    @Nonnull
    public VariablesApi getVariablesApi() {
        return new VariablesApiImpl(this.retrofit.create(VariablesService.class));
    }

    @Override
    @Nonnull
    public DashboardsApi getDashboardsApi() {
        return new DashboardsApiImpl(this.retrofit.create(DashboardsService.class));
    }

    @Override
    @Nonnull
    public ChecksApi getChecksApi() {
        return new ChecksApiImpl(this.retrofit.create(ChecksService.class));
    }

    @Override
    @Nonnull
    public NotificationEndpointsApi getNotificationEndpointsApi() {
        return new NotificationEndpointsApiImpl(this.retrofit.create(NotificationEndpointsService.class));
    }

    @Override
    @Nonnull
    public NotificationRulesApi getNotificationRulesApi() {
        return new NotificationRulesApiImpl(this.retrofit.create(NotificationRulesService.class));
    }

    @Override
    @Nonnull
    public DeleteApi getDeleteApi() {
        return new DeleteApiImpl(this.retrofit.create(DeleteService.class));
    }

    @Override
    @Nonnull
    public InvokableScriptsApi getInvokableScriptsApi() {
        return new InvokableScriptsApiImpl(this.retrofit.create(InvokableScriptsService.class));
    }

    @Override
    @Nonnull
    public InfluxQLQueryApi getInfluxQLQueryApi() {
        return new InfluxQLQueryApiImpl(this.getService(InfluxQLQueryService.class));
    }

    @Override
    @Nonnull
    public <S> S getService(@Nonnull Class<S> service) {
        Arguments.checkNotNull(service, "service");
        return this.retrofit.create(service);
    }

    @Override
    @Nonnull
    public HealthCheck health() {
        return this.health(this.healthService.getHealth(null));
    }

    @Override
    @Nonnull
    public Boolean ping() {
        return this.ping(this.pingService.getPing());
    }

    @Override
    @Nonnull
    public String version() {
        return this.version(this.pingService.getPing());
    }

    @Override
    @Nullable
    public Ready ready() {
        Call<Ready> call = this.readyService.getReady(null);
        try {
            return this.execute(call);
        }
        catch (InfluxException e) {
            LOG.log(Level.WARNING, "The exception occurs during check instance readiness", e);
            return null;
        }
    }

    @Override
    @Nonnull
    public OnboardingResponse onBoarding(@Nonnull OnboardingRequest onboarding) throws UnprocessableEntityException {
        Arguments.checkNotNull(onboarding, "onboarding");
        Call<OnboardingResponse> call = this.setupService.postSetup(onboarding, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Boolean isOnboardingAllowed() {
        IsOnboarding isOnboarding = this.execute(this.setupService.getSetup(null));
        return isOnboarding.getAllowed();
    }

    @Override
    @Nonnull
    public LogLevel getLogLevel() {
        return this.getLogLevel(this.loggingInterceptor);
    }

    @Override
    @Nonnull
    public InfluxDBClient setLogLevel(@Nonnull LogLevel logLevel) {
        this.setLogLevel(this.loggingInterceptor, logLevel);
        return this;
    }

    @Override
    @Nonnull
    public InfluxDBClient enableGzip() {
        this.gzipInterceptor.enableGzip();
        return this;
    }

    @Override
    @Nonnull
    public InfluxDBClient disableGzip() {
        this.gzipInterceptor.disableGzip();
        return this;
    }

    @Override
    public boolean isGzipEnabled() {
        return this.gzipInterceptor.isEnabledGzip();
    }
}

