/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.influxdb.client.LabelsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Label;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelCreateRequest;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelUpdate;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelsResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Organization;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.LabelsService;
import it.renvins.serverpulse.velocity.libs.influxdb.internal.AbstractRestClient;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class LabelsApiImpl
extends AbstractRestClient
implements LabelsApi {
    private static final Logger LOG = Logger.getLogger(LabelsApiImpl.class.getName());
    private final LabelsService service;

    LabelsApiImpl(@Nonnull LabelsService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Label createLabel(@Nonnull String name, @Nonnull Map<String, String> properties, @Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "orgID");
        Arguments.checkNonEmpty(name, "name");
        Arguments.checkNotNull(properties, "properties");
        LabelCreateRequest label = new LabelCreateRequest();
        label.setName(name);
        label.setProperties(properties);
        label.setOrgID(orgID);
        return this.createLabel(label);
    }

    @Override
    @Nonnull
    public Label createLabel(@Nonnull LabelCreateRequest request) {
        Arguments.checkNotNull(request, "request");
        Call<LabelResponse> call = this.service.postLabels(request);
        LabelResponse labelResponse = this.execute(call);
        LOG.log(Level.FINEST, "createLabel response: {0}", labelResponse);
        return labelResponse.getLabel();
    }

    @Override
    @Nonnull
    public Label updateLabel(@Nonnull Label label) {
        Arguments.checkNotNull(label, "label");
        LabelUpdate labelUpdate = new LabelUpdate();
        labelUpdate.properties(label.getProperties());
        return this.updateLabel(label.getId(), labelUpdate);
    }

    @Override
    @Nonnull
    public Label updateLabel(@Nonnull String labelID, @Nonnull LabelUpdate labelUpdate) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNotNull(labelUpdate, "labelUpdate");
        Call<LabelResponse> call = this.service.patchLabelsID(labelID, labelUpdate, null);
        LabelResponse labelResponse = this.execute(call);
        LOG.log(Level.FINEST, "updateLabel response: {0}", labelResponse);
        return labelResponse.getLabel();
    }

    @Override
    public void deleteLabel(@Nonnull Label label) {
        Arguments.checkNotNull(label, "label");
        this.deleteLabel(label.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Call<Void> call = this.service.deleteLabelsID(labelID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Label cloneLabel(@Nonnull String clonedName, @Nonnull String labelID) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNonEmpty(labelID, "labelID");
        Label label = this.findLabelByID(labelID);
        if (label == null) {
            throw new IllegalStateException("NotFound Label with ID: " + labelID);
        }
        return this.cloneLabel(clonedName, label);
    }

    @Override
    @Nonnull
    public Label cloneLabel(@Nonnull String clonedName, @Nonnull Label label) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNotNull(label, "label");
        LabelCreateRequest cloned = new LabelCreateRequest();
        cloned.setName(clonedName);
        cloned.setOrgID(label.getOrgID());
        if (label.getProperties() != null) {
            label.getProperties().forEach(cloned::putPropertiesItem);
        }
        cloned.getProperties().putAll(label.getProperties());
        return this.createLabel(cloned);
    }

    @Override
    @Nonnull
    public Label findLabelByID(@Nonnull String labelID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Call<LabelResponse> call = this.service.getLabelsID(labelID, null);
        return this.execute(call).getLabel();
    }

    @Override
    @Nonnull
    public List<Label> findLabels() {
        return this.findLabelsByOrgId(null);
    }

    @Override
    @Nonnull
    public List<Label> findLabelsByOrg(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "organization");
        return this.findLabelsByOrgId(organization.getId());
    }

    @Override
    @Nonnull
    public List<Label> findLabelsByOrgId(@Nullable String orgID) {
        Call<LabelsResponse> sourcesCall = this.service.getLabels(null, orgID);
        LabelsResponse labels = this.execute(sourcesCall);
        LOG.log(Level.FINEST, "findLabels found: {0}", labels);
        return labels.getLabels();
    }
}

