/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.influxdb.client.FindOptions;
import it.renvins.serverpulse.velocity.libs.influxdb.client.NotificationRulesApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HTTPNotificationEndpoint;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HTTPNotificationRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Label;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelMapping;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelsResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.NotificationEndpoint;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.NotificationRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.NotificationRuleUpdate;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.NotificationRules;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.PagerDutyNotificationEndpoint;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.PagerDutyNotificationRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.RuleStatusLevel;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.SlackNotificationEndpoint;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.SlackNotificationRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.StatusRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.TagRule;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.TaskStatusType;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.NotificationRulesService;
import it.renvins.serverpulse.velocity.libs.influxdb.internal.AbstractRestClient;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import java.util.Collections;
import java.util.List;

final class NotificationRulesApiImpl
extends AbstractRestClient
implements NotificationRulesApi {
    private final NotificationRulesService service;

    NotificationRulesApiImpl(@Nonnull NotificationRulesService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public SlackNotificationRule createSlackRule(@Nonnull String name, @Nonnull String every, @Nonnull String messageTemplate, @Nonnull RuleStatusLevel status, @Nonnull SlackNotificationEndpoint endpoint, @Nonnull String orgID) {
        return this.createSlackRule(name, every, messageTemplate, status, Collections.emptyList(), endpoint, orgID);
    }

    @Override
    @Nonnull
    public SlackNotificationRule createSlackRule(@Nonnull String name, @Nonnull String every, @Nonnull String messageTemplate, @Nonnull RuleStatusLevel status, @Nonnull List<TagRule> tagRules, @Nonnull SlackNotificationEndpoint endpoint, @Nonnull String orgID) {
        Arguments.checkNonEmpty(name, "name");
        Arguments.checkDuration(every, "every");
        Arguments.checkNonEmpty(messageTemplate, "messageTemplate");
        Arguments.checkNotNull((Object)status, "status");
        Arguments.checkNotNull(tagRules, "tagRules");
        Arguments.checkNotNull(endpoint, "endpoint");
        Arguments.checkNonEmpty(orgID, "orgID");
        SlackNotificationRule rule = new SlackNotificationRule();
        rule.setMessageTemplate(messageTemplate);
        return (SlackNotificationRule)this.createRule(name, every, status, tagRules, endpoint, orgID, rule);
    }

    @Override
    @Nonnull
    public PagerDutyNotificationRule createPagerDutyRule(@Nonnull String name, @Nonnull String every, @Nonnull String messageTemplate, @Nonnull RuleStatusLevel status, @Nonnull List<TagRule> tagRules, @Nonnull PagerDutyNotificationEndpoint endpoint, @Nonnull String orgID) {
        Arguments.checkNonEmpty(name, "name");
        Arguments.checkDuration(every, "every");
        Arguments.checkNonEmpty(messageTemplate, "messageTemplate");
        Arguments.checkNotNull((Object)status, "status");
        Arguments.checkNotNull(tagRules, "tagRules");
        Arguments.checkNotNull(endpoint, "endpoint");
        Arguments.checkNonEmpty(orgID, "orgID");
        PagerDutyNotificationRule rule = new PagerDutyNotificationRule();
        rule.setMessageTemplate(messageTemplate);
        return (PagerDutyNotificationRule)this.createRule(name, every, status, tagRules, endpoint, orgID, rule);
    }

    @Override
    @Nonnull
    public HTTPNotificationRule createHTTPRule(@Nonnull String name, @Nonnull String every, @Nonnull RuleStatusLevel status, @Nonnull List<TagRule> tagRules, @Nonnull HTTPNotificationEndpoint endpoint, @Nonnull String orgID) {
        HTTPNotificationRule rule = new HTTPNotificationRule();
        return (HTTPNotificationRule)this.createRule(name, every, status, tagRules, endpoint, orgID, rule);
    }

    @Override
    @Nonnull
    public NotificationRule createRule(@Nonnull NotificationRule rule) {
        Arguments.checkNotNull(rule, "rule");
        Call<NotificationRule> call = this.service.createNotificationRule(rule);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public NotificationRule updateNotificationRule(@Nonnull NotificationRule notificationRule) {
        Arguments.checkNotNull(notificationRule, "update");
        NotificationRuleUpdate update = new NotificationRuleUpdate().name(notificationRule.getName()).description(notificationRule.getDescription()).status(NotificationRuleUpdate.StatusEnum.fromValue(notificationRule.getStatus().getValue()));
        return this.updateNotificationRule(notificationRule.getId(), update);
    }

    @Override
    @Nonnull
    public NotificationRule updateNotificationRule(@Nonnull String ruleID, @Nonnull NotificationRuleUpdate update) {
        Arguments.checkNotNull(ruleID, "ruleID");
        Arguments.checkNotNull(update, "update");
        Call<NotificationRule> call = this.service.patchNotificationRulesID(ruleID, update, null);
        return this.execute(call);
    }

    @Override
    public void deleteNotificationRule(@Nonnull NotificationRule notificationRule) {
        Arguments.checkNotNull(notificationRule, "notificationRule");
        this.deleteNotificationRule(notificationRule.getId());
    }

    @Override
    public void deleteNotificationRule(@Nonnull String ruleID) {
        Arguments.checkNotNull(ruleID, "ruleID");
        Call<Void> call = this.service.deleteNotificationRulesID(ruleID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public NotificationRule findNotificationRuleByID(@Nonnull String ruleID) {
        Arguments.checkNotNull(ruleID, "ruleID");
        Call<NotificationRule> call = this.service.getNotificationRulesID(ruleID, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<NotificationRule> findNotificationRules(@Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "orgID");
        return this.findNotificationRules(orgID, new FindOptions()).getNotificationRules();
    }

    @Override
    @Nonnull
    public NotificationRules findNotificationRules(@Nonnull String orgID, @Nonnull FindOptions findOptions) {
        Arguments.checkNonEmpty(orgID, "orgID");
        Arguments.checkNotNull(findOptions, "findOptions");
        Call<NotificationRules> call = this.service.getNotificationRules(orgID, null, findOptions.getOffset(), findOptions.getLimit(), null, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull NotificationRule notificationRule) {
        Arguments.checkNotNull(notificationRule, "notificationRule");
        return this.getLabels(notificationRule.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String ruleID) {
        Arguments.checkNonEmpty(ruleID, "ruleID");
        Call<LabelsResponse> call = this.service.getNotificationRulesIDLabels(ruleID, null);
        return this.execute(call).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull NotificationRule notificationRule) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(notificationRule, "notificationRule");
        return this.addLabel(label.getId(), notificationRule.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String ruleID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(ruleID, "ruleID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postNotificationRuleIDLabels(ruleID, labelMapping, null);
        return this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull NotificationRule notificationRule) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(notificationRule, "check");
        this.deleteLabel(label.getId(), notificationRule.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String ruleID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(ruleID, "ruleID");
        Call<Void> call = this.service.deleteNotificationRulesIDLabelsID(ruleID, labelID, null);
        this.execute(call);
    }

    @Nonnull
    private NotificationRule createRule(@Nonnull String name, @Nonnull String every, @Nonnull RuleStatusLevel status, @Nonnull List<TagRule> tagRules, @Nonnull NotificationEndpoint notificationEndpoint, @Nonnull String orgID, @Nonnull NotificationRule rule) {
        Arguments.checkNotNull(rule, "rule");
        rule.setName(name);
        rule.setEvery(every);
        rule.setOrgID(orgID);
        rule.setTagRules(tagRules);
        rule.addStatusRulesItem(new StatusRule().currentLevel(status));
        rule.setEndpointID(notificationEndpoint.getId());
        rule.setStatus(TaskStatusType.ACTIVE);
        return this.createRule(rule);
    }
}

