/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.influxdb.client.WriteApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.AbstractWriteClient;
import it.renvins.serverpulse.velocity.libs.jetbrains.annotations.Nullable;
import it.renvins.serverpulse.velocity.libs.retrofit2.HttpException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class RetryAttempt {
    private static final Integer ABLE_TO_RETRY_ERROR = 429;
    private static final Logger LOG = Logger.getLogger(AbstractWriteClient.class.getName());
    private static Supplier<Double> jitterRandomSupplier;
    private static Supplier<Double> retryRandomSupplier;
    private final Throwable throwable;
    private final int count;
    private final WriteApi.RetryOptions writeOptions;

    RetryAttempt(Throwable throwable, int count, WriteApi.RetryOptions retryOptions) {
        this.throwable = throwable;
        this.count = count;
        this.writeOptions = retryOptions;
    }

    public static void setJitterRandomSupplier(@Nullable Supplier<Double> supplier) {
        jitterRandomSupplier = supplier;
    }

    public static void setRetryRandomSupplier(@Nullable Supplier<Double> supplier) {
        retryRandomSupplier = supplier;
    }

    boolean isRetry() {
        if (this.count > this.writeOptions.getMaxRetries()) {
            LOG.log(Level.WARNING, "Max write retries exceeded.", this.throwable);
            return false;
        }
        if (this.throwable instanceof HttpException) {
            HttpException he = (HttpException)this.throwable;
            return he.code() >= ABLE_TO_RETRY_ERROR;
        }
        if (this.throwable instanceof IOException) {
            if (this.throwable instanceof ProtocolException) {
                return false;
            }
            if (this.throwable instanceof InterruptedIOException) {
                return this.throwable instanceof SocketTimeoutException;
            }
            if (this.throwable instanceof SSLHandshakeException && this.throwable.getCause() instanceof CertificateException) {
                return false;
            }
            return !(this.throwable instanceof SSLPeerUnverifiedException);
        }
        return false;
    }

    long getRetryInterval() {
        String retryAfter = this.getRetryAfter();
        if (retryAfter != null) {
            long retryInterval = TimeUnit.MILLISECONDS.convert(Integer.parseInt(retryAfter), TimeUnit.SECONDS);
            return retryInterval + (long)RetryAttempt.jitterDelay(this.writeOptions.getJitterInterval());
        }
        long rangeStart = this.writeOptions.getRetryInterval();
        long rangeStop = (long)this.writeOptions.getRetryInterval() * (long)this.writeOptions.getExponentialBase();
        for (int i = 1; i < this.count; ++i) {
            rangeStart = rangeStop;
            if ((rangeStop *= (long)this.writeOptions.getExponentialBase()) <= (long)this.writeOptions.getMaxRetryDelay()) continue;
        }
        if (rangeStop > (long)this.writeOptions.getMaxRetryDelay()) {
            rangeStop = this.writeOptions.getMaxRetryDelay();
        }
        long retryInterval = (long)((double)rangeStart + (double)(rangeStop - rangeStart) * (retryRandomSupplier != null ? retryRandomSupplier.get() : Math.random()));
        String msg = "The InfluxDB does not specify \"Retry-After\". Use the default retryInterval: {0}";
        LOG.log(Level.FINEST, msg, retryInterval);
        LOG.log(Level.FINEST, "retry interval in range: [" + rangeStart + "," + rangeStop + "]");
        return retryInterval;
    }

    Throwable getThrowable() {
        return this.throwable;
    }

    @Nullable
    private String getRetryAfter() {
        if (this.throwable instanceof HttpException) {
            return ((HttpException)this.throwable).response().headers().get("Retry-After");
        }
        return null;
    }

    static int jitterDelay(int jitterInterval) {
        return (int)((jitterRandomSupplier != null ? jitterRandomSupplier.get() : Math.random()) * (double)jitterInterval);
    }
}

