/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.influxdb.client.ScraperTargetsApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.AddResourceMemberRequestBody;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Label;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelMapping;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelsResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Organization;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ResourceMember;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ResourceMembers;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ResourceOwner;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ResourceOwners;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ScraperTargetRequest;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ScraperTargetResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ScraperTargetResponses;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.User;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.ScraperTargetsService;
import it.renvins.serverpulse.velocity.libs.influxdb.internal.AbstractRestClient;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ScraperTargetsApiImpl
extends AbstractRestClient
implements ScraperTargetsApi {
    private static final Logger LOG = Logger.getLogger(ScraperTargetsApiImpl.class.getName());
    private final ScraperTargetsService service;

    ScraperTargetsApiImpl(@Nonnull ScraperTargetsService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public ScraperTargetResponse createScraperTarget(@Nonnull ScraperTargetRequest scraperTargetRequest) {
        Arguments.checkNotNull(scraperTargetRequest, "scraperTargetRequest");
        Call<ScraperTargetResponse> call = this.service.postScrapers(scraperTargetRequest, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public ScraperTargetResponse createScraperTarget(@Nonnull String name, @Nonnull String url, @Nonnull String bucketID, @Nonnull String orgID) {
        Arguments.checkNonEmpty(name, "name");
        Arguments.checkNonEmpty(url, "url");
        Arguments.checkNonEmpty(bucketID, "bucketID");
        Arguments.checkNonEmpty(orgID, " orgID");
        ScraperTargetRequest scraperTarget = new ScraperTargetRequest();
        scraperTarget.setName(name);
        scraperTarget.setUrl(url);
        scraperTarget.setBucketID(bucketID);
        scraperTarget.setOrgID(orgID);
        return this.createScraperTarget(scraperTarget);
    }

    @Override
    @Nonnull
    public ScraperTargetResponse updateScraperTarget(@Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        return this.updateScraperTarget(scraperTargetResponse.getId(), scraperTargetResponse);
    }

    @Override
    @Nonnull
    public ScraperTargetResponse updateScraperTarget(@Nonnull String scraperTargetID, @Nonnull ScraperTargetRequest scraperTargetRequest) {
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        Arguments.checkNotNull(scraperTargetRequest, "scraperTargetRequest");
        Call<ScraperTargetResponse> call = this.service.patchScrapersID(scraperTargetID, scraperTargetRequest, null);
        return this.execute(call);
    }

    @Override
    public void deleteScraperTarget(@Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        this.deleteScraperTarget(scraperTargetResponse.getId());
    }

    @Override
    public void deleteScraperTarget(@Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        Call<Void> call = this.service.deleteScrapersID(scraperTargetID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public ScraperTargetResponse cloneScraperTarget(@Nonnull String clonedName, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        ScraperTargetResponse scraperTarget = this.findScraperTargetByID(scraperTargetID);
        return this.cloneScraperTarget(clonedName, scraperTarget);
    }

    @Override
    @Nonnull
    public ScraperTargetResponse cloneScraperTarget(@Nonnull String clonedName, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        ScraperTargetRequest cloned = new ScraperTargetRequest();
        cloned.setName(clonedName);
        cloned.setUrl(scraperTargetResponse.getUrl());
        cloned.setOrgID(scraperTargetResponse.getOrgID());
        cloned.setBucketID(scraperTargetResponse.getBucketID());
        ScraperTargetResponse created = this.createScraperTarget(cloned);
        this.getLabels(scraperTargetResponse).forEach(label -> this.addLabel((Label)label, created));
        return created;
    }

    @Override
    @Nonnull
    public ScraperTargetResponse findScraperTargetByID(@Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        Call<ScraperTargetResponse> call = this.service.getScrapersID(scraperTargetID, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<ScraperTargetResponse> findScraperTargets() {
        return this.findScraperTargetsByOrgId(null);
    }

    @Override
    @Nonnull
    public List<ScraperTargetResponse> findScraperTargetsByOrg(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "organization");
        return this.findScraperTargetsByOrgId(organization.getId());
    }

    @Override
    @Nonnull
    public List<ScraperTargetResponse> findScraperTargetsByOrgId(@Nullable String orgID) {
        Call<ScraperTargetResponses> call = this.service.getScrapers(null, null, null, orgID, null);
        ScraperTargetResponses responses = this.execute(call);
        LOG.log(Level.FINEST, "findScraperTargets found: {0}", responses);
        return responses.getConfigurations();
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        return this.getMembers(scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public List<ResourceMember> getMembers(@Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        Call<ResourceMembers> call = this.service.getScrapersIDMembers(scraperTargetID, null);
        ResourceMembers resourceMembers = this.execute(call);
        LOG.log(Level.FINEST, "findScraperTargetMembers found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull User member, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        Arguments.checkNotNull(member, "member");
        return this.addMember(member.getId(), scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public ResourceMember addMember(@Nonnull String memberID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(memberID, "Member ID");
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(memberID);
        Call<ResourceMember> call = this.service.postScrapersIDMembers(scraperTargetID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteMember(@Nonnull User member, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        Arguments.checkNotNull(member, "member");
        this.deleteMember(member.getId(), scraperTargetResponse.getId());
    }

    @Override
    public void deleteMember(@Nonnull String memberID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(memberID, "Member ID");
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        Call<Void> call = this.service.deleteScrapersIDMembersID(memberID, scraperTargetID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        return this.getOwners(scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public List<ResourceOwner> getOwners(@Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        Call<ResourceOwners> call = this.service.getScrapersIDOwners(scraperTargetID, null);
        ResourceOwners resourceMembers = this.execute(call);
        LOG.log(Level.FINEST, "findScraperTargetOwners found: {0}", resourceMembers);
        return resourceMembers.getUsers();
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull User owner, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        Arguments.checkNotNull(owner, "owner");
        return this.addOwner(owner.getId(), scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public ResourceOwner addOwner(@Nonnull String ownerID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(ownerID, "Owner ID");
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        AddResourceMemberRequestBody user = new AddResourceMemberRequestBody();
        user.setId(ownerID);
        Call<ResourceOwner> call = this.service.postScrapersIDOwners(scraperTargetID, user, null);
        return this.execute(call);
    }

    @Override
    public void deleteOwner(@Nonnull User owner, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        Arguments.checkNotNull(owner, "owner");
        this.deleteOwner(owner.getId(), scraperTargetResponse.getId());
    }

    @Override
    public void deleteOwner(@Nonnull String ownerID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(ownerID, "Owner ID");
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        Call<Void> call = this.service.deleteScrapersIDOwnersID(ownerID, scraperTargetID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        return this.getLabels(scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        Call<LabelsResponse> call = this.service.getScrapersIDLabels(scraperTargetID, null);
        return this.execute(call).getLabels();
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull Label label, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        return this.addLabel(label.getId(), scraperTargetResponse.getId());
    }

    @Override
    @Nonnull
    public LabelResponse addLabel(@Nonnull String labelID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        LabelMapping labelMapping = new LabelMapping();
        labelMapping.setLabelID(labelID);
        Call<LabelResponse> call = this.service.postScrapersIDLabels(scraperTargetID, labelMapping, null);
        return this.execute(call);
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull ScraperTargetResponse scraperTargetResponse) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(scraperTargetResponse, "scraperTarget");
        this.deleteLabel(label.getId(), scraperTargetResponse.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String scraperTargetID) {
        Arguments.checkNonEmpty(labelID, "labelID");
        Arguments.checkNonEmpty(scraperTargetID, "scraperTargetID");
        Call<Void> call = this.service.deleteScrapersIDLabelsID(scraperTargetID, labelID, null);
        this.execute(call);
    }
}

