/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.influxdb.client.SourcesApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Bucket;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Buckets;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.HealthCheck;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Source;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Sources;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.InfluxDBClientImpl;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.SourcesService;
import it.renvins.serverpulse.velocity.libs.influxdb.internal.AbstractRestClient;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SourcesApiImpl
extends AbstractRestClient
implements SourcesApi {
    private static final Logger LOG = Logger.getLogger(SourcesApiImpl.class.getName());
    private final InfluxDBClientImpl influxDBClient;
    private final SourcesService service;

    SourcesApiImpl(@Nonnull SourcesService service, @Nonnull InfluxDBClientImpl influxDBClient) {
        Arguments.checkNotNull(service, "service");
        Arguments.checkNotNull(influxDBClient, "influxDBClient");
        this.service = service;
        this.influxDBClient = influxDBClient;
    }

    @Override
    @Nonnull
    public Source createSource(@Nonnull Source source2) {
        Arguments.checkNotNull(source2, "Source is required");
        Call<Source> call = this.service.postSources(source2, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Source updateSource(@Nonnull Source source2) {
        Arguments.checkNotNull(source2, "Source is required");
        Call<Source> call = this.service.patchSourcesID(source2.getId(), source2, null);
        return this.execute(call);
    }

    @Override
    public void deleteSource(@Nonnull Source source2) {
        Arguments.checkNotNull(source2, "Source is required");
        this.deleteSource(source2.getId());
    }

    @Override
    public void deleteSource(@Nonnull String sourceID) {
        Arguments.checkNonEmpty(sourceID, "sourceID");
        Call<Void> call = this.service.deleteSourcesID(sourceID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Source cloneSource(@Nonnull String clonedName, @Nonnull String sourceID) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNonEmpty(sourceID, "sourceID");
        Source source2 = this.findSourceByID(sourceID);
        return this.cloneSource(clonedName, source2);
    }

    @Override
    @Nonnull
    public Source cloneSource(@Nonnull String clonedName, @Nonnull Source source2) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNotNull(source2, "source");
        Source cloned = new Source();
        cloned.setName(clonedName);
        cloned.setOrgID(source2.getOrgID());
        cloned.setDefault(source2.getDefault());
        cloned.setType(source2.getType());
        cloned.setUrl(source2.getUrl());
        cloned.setInsecureSkipVerify(source2.getInsecureSkipVerify());
        cloned.setTelegraf(source2.getTelegraf());
        cloned.setToken(source2.getToken());
        cloned.setUsername(source2.getUsername());
        cloned.setPassword(source2.getPassword());
        cloned.setSharedSecret(source2.getSharedSecret());
        cloned.setMetaUrl(source2.getMetaUrl());
        cloned.setDefaultRP(source2.getDefaultRP());
        return this.createSource(cloned);
    }

    @Override
    @Nonnull
    public Source findSourceByID(@Nonnull String sourceID) {
        Arguments.checkNonEmpty(sourceID, "sourceID");
        Call<Source> call = this.service.getSourcesID(sourceID, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<Source> findSources() {
        Call<Sources> sourcesCall = this.service.getSources(null, null);
        Sources sources = this.execute(sourcesCall);
        LOG.log(Level.FINEST, "findSources found: {0}", sources);
        return sources.getSources();
    }

    @Override
    @Nullable
    public List<Bucket> findBucketsBySource(@Nonnull Source source2) {
        Arguments.checkNotNull(source2, "Source is required");
        return this.findBucketsBySourceID(source2.getId());
    }

    @Override
    @Nonnull
    public List<Bucket> findBucketsBySourceID(@Nonnull String sourceID) {
        Arguments.checkNonEmpty(sourceID, "sourceID");
        Call<Buckets> call = this.service.getSourcesIDBuckets(sourceID, null, null);
        return this.execute(call).getBuckets();
    }

    @Override
    @Nonnull
    public HealthCheck health(@Nonnull Source source2) {
        Arguments.checkNotNull(source2, "Source is required");
        return this.health(source2.getId());
    }

    @Override
    @Nonnull
    public HealthCheck health(@Nonnull String sourceID) {
        Arguments.checkNonEmpty(sourceID, "sourceID");
        return this.influxDBClient.health(this.service.getSourcesIDHealth(sourceID, null));
    }
}

