/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.influxdb.client.UsersApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.PasswordResetBody;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.PostUser;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.User;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Users;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.UsersService;
import it.renvins.serverpulse.velocity.libs.influxdb.internal.AbstractRestClient;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.okhttp3.Credentials;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class UsersApiImpl
extends AbstractRestClient
implements UsersApi {
    private static final Logger LOG = Logger.getLogger(UsersApiImpl.class.getName());
    private final UsersService service;

    UsersApiImpl(@Nonnull UsersService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public User findUserByID(@Nonnull String userID) {
        Arguments.checkNonEmpty(userID, "User ID");
        Call<User> user = this.service.getUsersID(userID, null);
        return this.execute(user);
    }

    @Override
    @Nonnull
    public List<User> findUsers() {
        Call<Users> usersCall = this.service.getUsers(null, null, null, null, null, null);
        Users users = this.execute(usersCall);
        LOG.log(Level.FINEST, "findUsers found: {0}", users);
        return users.getUsers();
    }

    @Override
    @Nonnull
    public User createUser(@Nonnull String name) {
        Arguments.checkNonEmpty(name, "User name");
        User user = new User();
        user.setName(name);
        return this.createUser(user);
    }

    @Override
    @Nonnull
    public User createUser(@Nonnull User user) {
        Arguments.checkNotNull(user, "User");
        PostUser request = new PostUser().oauthID(user.getOauthID()).name(user.getName()).status(PostUser.StatusEnum.fromValue(user.getStatus().getValue()));
        Call<User> call = this.service.postUsers(request, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public User updateUser(@Nonnull User user) {
        Arguments.checkNotNull(user, "User");
        PostUser request = new PostUser().oauthID(user.getOauthID()).name(user.getName()).status(PostUser.StatusEnum.fromValue(user.getStatus().getValue()));
        Call<User> userCall = this.service.patchUsersID(user.getId(), request, null);
        return this.execute(userCall);
    }

    @Override
    public void updateUserPassword(@Nonnull User user, @Nonnull String oldPassword, @Nonnull String newPassword) {
        Arguments.checkNotNull(user, "User");
        Arguments.checkNotNull(oldPassword, "old password");
        Arguments.checkNotNull(newPassword, "new password");
        this.updateUserPassword(user.getId(), user.getName(), oldPassword, newPassword);
    }

    @Override
    public void updateUserPassword(@Nonnull String userID, @Nonnull String oldPassword, @Nonnull String newPassword) {
        Arguments.checkNotNull(userID, "User ID");
        Arguments.checkNotNull(oldPassword, "old password");
        Arguments.checkNotNull(newPassword, "new password");
        Call<User> userByID = this.service.getUsersID(userID, null);
        User user = this.execute(userByID);
        this.updateUserPassword(userID, user.getName(), oldPassword, newPassword);
    }

    @Override
    public void deleteUser(@Nonnull User user) {
        Arguments.checkNotNull(user, "User");
        this.deleteUser(user.getId());
    }

    @Override
    public void deleteUser(@Nonnull String userID) {
        Arguments.checkNonEmpty(userID, "User ID");
        Call<Void> call = this.service.deleteUsersID(userID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public User cloneUser(@Nonnull String clonedName, @Nonnull String userID) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNonEmpty(userID, "userID");
        User user = this.findUserByID(userID);
        return this.cloneUser(clonedName, user);
    }

    @Override
    @Nonnull
    public User cloneUser(@Nonnull String clonedName, @Nonnull User user) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNotNull(user, "User");
        User cloned = new User();
        cloned.setName(clonedName);
        return this.createUser(cloned);
    }

    @Override
    @Nonnull
    public User me() {
        Call<User> call = this.service.getMe(null);
        return this.execute(call);
    }

    @Override
    public void meUpdatePassword(@Nonnull String oldPassword, @Nonnull String newPassword) {
        Arguments.checkNotNull(oldPassword, "old password");
        Arguments.checkNotNull(newPassword, "new password");
        User user = this.me();
        String credentials = Credentials.basic(user.getName(), oldPassword);
        PasswordResetBody passwordResetBody = new PasswordResetBody().password(newPassword);
        Call<Void> call = this.service.putMePassword(passwordResetBody, null, credentials);
        this.execute(call);
    }

    private void updateUserPassword(@Nonnull String userID, @Nonnull String userName, @Nonnull String oldPassword, @Nonnull String newPassword) {
        Arguments.checkNotNull(userID, "User ID");
        Arguments.checkNotNull(userName, "Username");
        Arguments.checkNotNull(oldPassword, "old password");
        Arguments.checkNotNull(newPassword, "new password");
        String credentials = Credentials.basic(userName, oldPassword);
        PasswordResetBody resetBody = new PasswordResetBody().password(newPassword);
        Call<Void> call = this.service.postUsersIDPassword(userID, resetBody, null, credentials);
        this.execute(call);
    }
}

