/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.influxdb.client.VariablesApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Label;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelMapping;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelsResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Organization;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Variable;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Variables;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.VariablesService;
import it.renvins.serverpulse.velocity.libs.influxdb.internal.AbstractRestClient;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import java.util.List;

final class VariablesApiImpl
extends AbstractRestClient
implements VariablesApi {
    private final VariablesService service;

    VariablesApiImpl(@Nonnull VariablesService service) {
        Arguments.checkNotNull(service, "service");
        this.service = service;
    }

    @Override
    @Nonnull
    public Variable createVariable(@Nonnull Variable variable) {
        Arguments.checkNotNull(variable, "variable");
        Call<Variable> call = this.service.postVariables(variable, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public Variable updateVariable(@Nonnull Variable variable) {
        Arguments.checkNotNull(variable, "variable");
        Call<Variable> call = this.service.patchVariablesID(variable.getId(), variable, null);
        return this.execute(call);
    }

    @Override
    public void deleteVariable(@Nonnull Variable variable) {
        Arguments.checkNotNull(variable, "variable");
        this.deleteVariable(variable.getId());
    }

    @Override
    public void deleteVariable(@Nonnull String variableID) {
        Arguments.checkNonEmpty(variableID, "variableID");
        Call<Void> call = this.service.deleteVariablesID(variableID, null);
        this.execute(call);
    }

    @Override
    @Nonnull
    public Variable cloneVariable(@Nonnull String clonedName, @Nonnull String variableID) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNonEmpty(variableID, "variableID");
        return this.cloneVariable(clonedName, this.findVariableByID(variableID));
    }

    @Override
    @Nonnull
    public Variable cloneVariable(@Nonnull String clonedName, @Nonnull Variable variable) {
        Arguments.checkNonEmpty(clonedName, "clonedName");
        Arguments.checkNotNull(variable, "variable");
        Variable cloned = new Variable();
        cloned.name(clonedName).orgID(variable.getOrgID()).selected(variable.getSelected()).arguments(variable.getArguments());
        return this.createVariable(cloned);
    }

    @Override
    @Nonnull
    public Variable findVariableByID(@Nonnull String variableID) {
        Arguments.checkNonEmpty(variableID, "variableID");
        Call<Variable> call = this.service.getVariablesID(variableID, null);
        return this.execute(call);
    }

    @Override
    @Nonnull
    public List<Variable> findVariables(@Nonnull Organization organization) {
        Arguments.checkNotNull(organization, "organization");
        return this.findVariables(organization.getId());
    }

    @Override
    @Nonnull
    public List<Variable> findVariables(@Nonnull String orgID) {
        Arguments.checkNonEmpty(orgID, "orgID");
        Call<Variables> call = this.service.getVariables(null, null, orgID);
        return this.execute(call).getVariables();
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull Variable variable) {
        Arguments.checkNotNull(variable, "variable");
        return this.getLabels(variable.getId());
    }

    @Override
    @Nonnull
    public List<Label> getLabels(@Nonnull String variableID) {
        Arguments.checkNonEmpty("variableID", variableID);
        Call<LabelsResponse> call = this.service.getVariablesIDLabels(variableID, null);
        return this.execute(call).getLabels();
    }

    @Override
    @Nonnull
    public Label addLabel(@Nonnull Label label, @Nonnull Variable variable) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(variable, "variable");
        return this.addLabel(label.getId(), variable.getId());
    }

    @Override
    @Nonnull
    public Label addLabel(@Nonnull String labelID, @Nonnull String variableID) {
        Arguments.checkNonEmpty("variableID", variableID);
        Arguments.checkNonEmpty("labelID", labelID);
        Call<LabelResponse> call = this.service.postVariablesIDLabels(variableID, new LabelMapping().labelID(labelID), null);
        return this.execute(call).getLabel();
    }

    @Override
    public void deleteLabel(@Nonnull Label label, @Nonnull Variable variable) {
        Arguments.checkNotNull(label, "label");
        Arguments.checkNotNull(variable, "variable");
        this.deleteLabel(label.getId(), variable.getId());
    }

    @Override
    public void deleteLabel(@Nonnull String labelID, @Nonnull String variableID) {
        Arguments.checkNonEmpty("variableID", variableID);
        Arguments.checkNonEmpty("labelID", labelID);
        Call<Void> call = this.service.deleteVariablesIDLabelsID(variableID, labelID, null);
        this.execute(call);
    }
}

