/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.influxdb.client.InfluxDBClientOptions;
import it.renvins.serverpulse.velocity.libs.influxdb.client.WriteApi;
import it.renvins.serverpulse.velocity.libs.influxdb.client.WriteOptions;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.WritePrecision;
import it.renvins.serverpulse.velocity.libs.influxdb.client.internal.AbstractWriteClient;
import it.renvins.serverpulse.velocity.libs.influxdb.client.service.WriteService;
import it.renvins.serverpulse.velocity.libs.influxdb.client.write.Point;
import it.renvins.serverpulse.velocity.libs.influxdb.client.write.WriteParameters;
import it.renvins.serverpulse.velocity.libs.influxdb.client.write.events.AbstractWriteEvent;
import it.renvins.serverpulse.velocity.libs.influxdb.client.write.events.EventListener;
import it.renvins.serverpulse.velocity.libs.influxdb.client.write.events.ListenerRegistration;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Flowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class WriteApiImpl
extends AbstractWriteClient
implements WriteApi {
    WriteApiImpl(@Nonnull WriteOptions writeOptions, @Nonnull WriteService service, @Nonnull InfluxDBClientOptions options, Collection<AutoCloseable> autoCloseables) {
        super(writeOptions, options, writeOptions.getWriteScheduler(), service, autoCloseables);
    }

    @Override
    public void writeRecord(@Nonnull WritePrecision precision, @Nullable String record) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writeRecord(this.options.getBucket(), this.options.getOrg(), precision, record);
    }

    @Override
    public void writeRecord(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable String record) {
        Arguments.checkNonEmpty(bucket, "bucket");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull((Object)precision, "WritePrecision is required");
        this.writeRecord(record, new WriteParameters(bucket, org, precision));
    }

    @Override
    public void writeRecord(@Nullable String record, @Nonnull WriteParameters parameters) {
        if (record == null) {
            return;
        }
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        this.write(parameters, Flowable.just(new AbstractWriteClient.BatchWriteDataRecord(record)));
    }

    @Override
    public void writeRecords(@Nonnull WritePrecision precision, @Nonnull List<String> records) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writeRecords(this.options.getBucket(), this.options.getOrg(), precision, records);
    }

    @Override
    public void writeRecords(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull List<String> records) {
        Arguments.checkNonEmpty(bucket, "bucket");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull((Object)precision, "WritePrecision is required");
        Arguments.checkNotNull(records, "records");
        this.writeRecords(records, new WriteParameters(bucket, org, precision));
    }

    @Override
    public void writeRecords(@Nonnull List<String> records, @Nonnull WriteParameters parameters) {
        Arguments.checkNotNull(records, "records");
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        Flowable<AbstractWriteClient.BatchWriteData> stream = Flowable.fromIterable(records).map(AbstractWriteClient.BatchWriteDataRecord::new);
        this.write(parameters, stream);
    }

    @Override
    public void writePoint(@Nullable Point point) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writePoint(this.options.getBucket(), this.options.getOrg(), point);
    }

    @Override
    public void writePoint(@Nonnull String bucket, @Nonnull String org, @Nullable Point point) {
        this.writePoint(point, new WriteParameters(bucket, org, WriteParameters.DEFAULT_WRITE_PRECISION));
    }

    @Override
    public void writePoint(@Nullable Point point, @Nonnull WriteParameters parameters) {
        if (point == null) {
            return;
        }
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        this.writePoints(Collections.singletonList(point), parameters);
    }

    @Override
    public void writePoints(@Nonnull List<Point> points) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writePoints(this.options.getBucket(), this.options.getOrg(), points);
    }

    @Override
    public void writePoints(@Nonnull String bucket, @Nonnull String org, @Nonnull List<Point> points) {
        Arguments.checkNonEmpty(bucket, "bucket");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull(points, "points");
        this.writePoints(points, new WriteParameters(bucket, org, WriteParameters.DEFAULT_WRITE_PRECISION));
    }

    @Override
    public void writePoints(@Nonnull List<Point> points, @Nonnull WriteParameters parameters) {
        Arguments.checkNotNull(points, "points");
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        Flowable<AbstractWriteClient.BatchWriteDataPoint> stream = Flowable.fromIterable(points).filter(Objects::nonNull).map(point -> new AbstractWriteClient.BatchWriteDataPoint((Point)point, this.options));
        this.writePoints(parameters, stream);
    }

    @Override
    public <M> void writeMeasurement(@Nonnull WritePrecision precision, @Nullable M measurement) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writeMeasurement(this.options.getBucket(), this.options.getOrg(), precision, measurement);
    }

    @Override
    public <M> void writeMeasurement(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nullable M measurement) {
        this.writeMeasurement(measurement, new WriteParameters(bucket, org, precision));
    }

    @Override
    public <M> void writeMeasurement(@Nullable M measurement, @Nonnull WriteParameters parameters) {
        if (measurement == null) {
            return;
        }
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        this.writeMeasurements(Collections.singletonList(measurement), parameters);
    }

    @Override
    public <M> void writeMeasurements(@Nonnull WritePrecision precision, @Nonnull List<M> measurements) {
        Arguments.checkNotNull(this.options.getBucket(), "InfluxDBClientOptions.getBucket");
        Arguments.checkNotNull(this.options.getOrg(), "InfluxDBClientOptions.getOrg");
        this.writeMeasurements(this.options.getBucket(), this.options.getOrg(), precision, measurements);
    }

    @Override
    public <M> void writeMeasurements(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision, @Nonnull List<M> measurements) {
        Arguments.checkNonEmpty(bucket, "bucket");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull((Object)precision, "WritePrecision is required");
        Arguments.checkNotNull(measurements, "records");
        this.writeMeasurements(measurements, new WriteParameters(bucket, org, precision));
    }

    @Override
    public <M> void writeMeasurements(@Nonnull List<M> measurements, @Nonnull WriteParameters parameters) {
        Arguments.checkNotNull(measurements, "points");
        Arguments.checkNotNull(parameters, "WriteParameters");
        parameters.check(this.options);
        Flowable<AbstractWriteClient.BatchWriteData> stream = Flowable.fromIterable(measurements).map(it -> new AbstractWriteClient.BatchWriteDataMeasurement(it, parameters.precisionSafe(this.options), this.options, this.measurementMapper));
        this.write(parameters, stream);
    }

    @Override
    @Nonnull
    public <T extends AbstractWriteEvent> ListenerRegistration listenEvents(@Nonnull Class<T> eventType, @Nonnull EventListener<T> listener) {
        Arguments.checkNotNull(eventType, "Type of listener");
        Arguments.checkNotNull(listener, "Listener");
        Disposable subscribe = super.addEventListener(eventType).subscribe(listener::onEvent);
        return subscribe::dispose;
    }

    @Override
    public void close() {
        super.close();
    }
}

