/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.service;

import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.AddResourceMemberRequestBody;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Cell;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.CellUpdate;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.CreateCell;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.CreateDashboardRequest;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Dashboard;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.Dashboards;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelMapping;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.LabelsResponse;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.PatchDashboardRequest;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ResourceMember;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ResourceMembers;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ResourceOwner;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.ResourceOwners;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.View;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.Body;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.DELETE;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.GET;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.Header;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.Headers;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.PATCH;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.POST;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.PUT;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.Path;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.Query;
import java.util.List;

public interface DashboardsService {
    @DELETE(value="api/v2/dashboards/{dashboardID}")
    public Call<Void> deleteDashboardsID(@Path(value="dashboardID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @DELETE(value="api/v2/dashboards/{dashboardID}/cells/{cellID}")
    public Call<Void> deleteDashboardsIDCellsID(@Path(value="dashboardID") String var1, @Path(value="cellID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/dashboards/{dashboardID}/labels/{labelID}")
    public Call<Void> deleteDashboardsIDLabelsID(@Path(value="dashboardID") String var1, @Path(value="labelID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/dashboards/{dashboardID}/members/{userID}")
    public Call<Void> deleteDashboardsIDMembersID(@Path(value="userID") String var1, @Path(value="dashboardID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @DELETE(value="api/v2/dashboards/{dashboardID}/owners/{userID}")
    public Call<Void> deleteDashboardsIDOwnersID(@Path(value="userID") String var1, @Path(value="dashboardID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @GET(value="api/v2/dashboards")
    public Call<Dashboards> getDashboards(@Header(value="Zap-Trace-Span") String var1, @Query(value="offset") Integer var2, @Query(value="limit") Integer var3, @Query(value="descending") Boolean var4, @Query(value="owner") String var5, @Query(value="sortBy") String var6, @Query(value="id") List<String> var7, @Query(value="orgID") String var8, @Query(value="org") String var9);

    @GET(value="api/v2/dashboards/{dashboardID}")
    public Call<Dashboard> getDashboardsID(@Path(value="dashboardID") String var1, @Header(value="Zap-Trace-Span") String var2, @Query(value="include") String var3);

    @GET(value="api/v2/dashboards/{dashboardID}/cells/{cellID}/view")
    public Call<View> getDashboardsIDCellsIDView(@Path(value="dashboardID") String var1, @Path(value="cellID") String var2, @Header(value="Zap-Trace-Span") String var3);

    @GET(value="api/v2/dashboards/{dashboardID}/labels")
    public Call<LabelsResponse> getDashboardsIDLabels(@Path(value="dashboardID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/dashboards/{dashboardID}/members")
    public Call<ResourceMembers> getDashboardsIDMembers(@Path(value="dashboardID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @GET(value="api/v2/dashboards/{dashboardID}/owners")
    public Call<ResourceOwners> getDashboardsIDOwners(@Path(value="dashboardID") String var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/v2/dashboards/{dashboardID}")
    public Call<Dashboard> patchDashboardsID(@Path(value="dashboardID") String var1, @Header(value="Zap-Trace-Span") String var2, @Body PatchDashboardRequest var3);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/v2/dashboards/{dashboardID}/cells/{cellID}")
    public Call<Cell> patchDashboardsIDCellsID(@Path(value="dashboardID") String var1, @Path(value="cellID") String var2, @Body CellUpdate var3, @Header(value="Zap-Trace-Span") String var4);

    @Headers(value={"Content-Type:application/json"})
    @PATCH(value="api/v2/dashboards/{dashboardID}/cells/{cellID}/view")
    public Call<View> patchDashboardsIDCellsIDView(@Path(value="dashboardID") String var1, @Path(value="cellID") String var2, @Body View var3, @Header(value="Zap-Trace-Span") String var4);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/dashboards")
    public Call<Dashboard> postDashboards(@Body CreateDashboardRequest var1, @Header(value="Zap-Trace-Span") String var2);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/dashboards/{dashboardID}/cells")
    public Call<Cell> postDashboardsIDCells(@Path(value="dashboardID") String var1, @Body CreateCell var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/dashboards/{dashboardID}/labels")
    public Call<LabelResponse> postDashboardsIDLabels(@Path(value="dashboardID") String var1, @Body LabelMapping var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/dashboards/{dashboardID}/members")
    public Call<ResourceMember> postDashboardsIDMembers(@Path(value="dashboardID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @POST(value="api/v2/dashboards/{dashboardID}/owners")
    public Call<ResourceOwner> postDashboardsIDOwners(@Path(value="dashboardID") String var1, @Body AddResourceMemberRequestBody var2, @Header(value="Zap-Trace-Span") String var3);

    @Headers(value={"Content-Type:application/json"})
    @PUT(value="api/v2/dashboards/{dashboardID}/cells")
    public Call<Dashboard> putDashboardsIDCells(@Path(value="dashboardID") String var1, @Body List<Cell> var2, @Header(value="Zap-Trace-Span") String var3);
}

